/*
 * Decompiled with CFR 0.152.
 */
package hlt.fot;

import hlt.fot.FirstOrderTermPair;
import hlt.fot.FirstOrderTermStructure;
import hlt.fot.Functor;
import hlt.fot.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public interface FirstOrderTerm {
    public static final Stack unifyStack = new Stack();
    public static final ArrayList generatedVariables = new ArrayList();
    public static final HashMap lSubstitution = new HashMap();
    public static final HashMap rSubstitution = new HashMap();

    public boolean isVariable();

    public FirstOrderTerm deref();

    default public String derefToString() {
        return this.deref().toString();
    }

    public boolean equal(FirstOrderTerm var1);

    public static boolean unify(FirstOrderTerm firstOrderTerm, FirstOrderTerm firstOrderTerm2) {
        unifyStack.clear();
        unifyStack.push(firstOrderTerm);
        unifyStack.push(firstOrderTerm2);
        boolean bl = true;
        while (bl && !unifyStack.isEmpty()) {
            FirstOrderTerm firstOrderTerm3;
            firstOrderTerm = (FirstOrderTerm)unifyStack.pop();
            firstOrderTerm2 = (FirstOrderTerm)unifyStack.pop();
            if (firstOrderTerm.isVariable()) {
                firstOrderTerm = ((Variable)firstOrderTerm).deref();
            }
            if (firstOrderTerm2.isVariable()) {
                firstOrderTerm2 = ((Variable)firstOrderTerm2).deref();
            }
            if (firstOrderTerm == firstOrderTerm2) continue;
            if (firstOrderTerm.isVariable()) {
                firstOrderTerm3 = (Variable)firstOrderTerm;
                if (((Variable)firstOrderTerm3).occursIn(firstOrderTerm2)) {
                    bl = false;
                    continue;
                }
                ((Variable)firstOrderTerm3).bind(firstOrderTerm2);
                continue;
            }
            if (firstOrderTerm2.isVariable()) {
                firstOrderTerm3 = (Variable)firstOrderTerm2;
                if (((Variable)firstOrderTerm3).occursIn(firstOrderTerm)) {
                    bl = false;
                    continue;
                }
                ((Variable)firstOrderTerm3).bind(firstOrderTerm);
                continue;
            }
            firstOrderTerm3 = (FirstOrderTermStructure)firstOrderTerm;
            FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm2;
            if (((FirstOrderTermStructure)firstOrderTerm3).functor().equal(firstOrderTermStructure.functor())) {
                for (int i = 1; i <= ((FirstOrderTermStructure)firstOrderTerm3).functor.arity(); ++i) {
                    unifyStack.push(((FirstOrderTermStructure)firstOrderTerm3).argument(i));
                    unifyStack.push(firstOrderTermStructure.argument(i));
                }
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public static void resetGeneralizer() {
        generatedVariables.clear();
        lSubstitution.clear();
        rSubstitution.clear();
    }

    private static FirstOrderTermPair unapply(FirstOrderTerm firstOrderTerm, FirstOrderTerm firstOrderTerm2) {
        for (int i = 0; i < generatedVariables.size(); ++i) {
            Variable variable = (Variable)generatedVariables.get(i);
            FirstOrderTerm firstOrderTerm3 = (FirstOrderTerm)lSubstitution.get(variable);
            FirstOrderTerm firstOrderTerm4 = (FirstOrderTerm)rSubstitution.get(variable);
            if (!firstOrderTerm.equal(firstOrderTerm3) || !firstOrderTerm2.equal(firstOrderTerm4)) continue;
            return new FirstOrderTermPair(variable, variable);
        }
        return new FirstOrderTermPair(firstOrderTerm, firstOrderTerm2);
    }

    public static FirstOrderTerm generalize(FirstOrderTerm firstOrderTerm, FirstOrderTerm firstOrderTerm2) {
        if (firstOrderTerm.isVariable() && firstOrderTerm == firstOrderTerm2) {
            return firstOrderTerm;
        }
        if ((firstOrderTerm.isVariable() || firstOrderTerm2.isVariable()) && !firstOrderTerm.equal(firstOrderTerm2)) {
            Variable variable = Variable.anonymousVariable();
            lSubstitution.put(variable, firstOrderTerm);
            rSubstitution.put(variable, firstOrderTerm2);
            generatedVariables.add(variable);
            return variable;
        }
        FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm;
        FirstOrderTermStructure firstOrderTermStructure2 = (FirstOrderTermStructure)firstOrderTerm2;
        if (!firstOrderTermStructure.functor().equal(firstOrderTermStructure2.functor())) {
            Variable variable = Variable.anonymousVariable();
            lSubstitution.put(variable, firstOrderTerm);
            rSubstitution.put(variable, firstOrderTerm2);
            generatedVariables.add(variable);
            return variable;
        }
        Functor functor = firstOrderTermStructure.functor();
        int n = functor.arity();
        FirstOrderTermStructure firstOrderTermStructure3 = n == 0 ? new FirstOrderTermStructure(functor) : new FirstOrderTermStructure(functor, new FirstOrderTerm[n]);
        for (int i = 1; i <= n; ++i) {
            FirstOrderTermPair firstOrderTermPair = FirstOrderTerm.unapply(firstOrderTermStructure.argument(i), firstOrderTermStructure2.argument(i));
            firstOrderTermStructure3.setArgument(i, FirstOrderTerm.generalize(firstOrderTermPair.left(), firstOrderTermPair.right()));
        }
        return firstOrderTermStructure3;
    }
}

