/*
 * Decompiled with CFR 0.152.
 */
package hlt.fot;

import hlt.fot.FirstOrderTerm;
import hlt.fot.Functor;

public class FirstOrderTermStructure
implements FirstOrderTerm {
    protected Functor functor;
    protected FirstOrderTerm[] arguments;
    private String stringForm;

    public Functor functor() {
        return this.functor;
    }

    public FirstOrderTerm[] arguments() {
        return this.arguments;
    }

    protected FirstOrderTermStructure() {
    }

    public FirstOrderTermStructure(Functor functor) {
        this.functor = functor;
    }

    public FirstOrderTermStructure(Functor functor, FirstOrderTerm[] firstOrderTermArray) {
        this.functor = functor;
        this.arguments = firstOrderTermArray;
    }

    public FirstOrderTerm argument(int n) {
        return this.arguments == null ? null : this.arguments[n - 1];
    }

    public void setArgument(int n, FirstOrderTerm firstOrderTerm) {
        this.arguments[n - 1] = firstOrderTerm;
    }

    @Override
    public final boolean isVariable() {
        return false;
    }

    public final boolean isConstant() {
        return this.functor.arity() == 0;
    }

    @Override
    public FirstOrderTerm deref() {
        if (this.isConstant()) {
            return this;
        }
        FirstOrderTerm[] firstOrderTermArray = new FirstOrderTerm[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            firstOrderTermArray[i] = this.arguments[i].deref();
        }
        return new FirstOrderTermStructure(this.functor, firstOrderTermArray);
    }

    public String toString() {
        if (this.stringForm != null) {
            return this.stringForm;
        }
        StringBuffer stringBuffer = new StringBuffer(this.functor.name());
        if (!this.isConstant()) {
            stringBuffer.append("(");
            for (int i = 1; i <= this.functor.arity(); ++i) {
                stringBuffer.append(this.argument(i).toString() + (i == this.functor.arity() ? ")" : ","));
            }
        }
        this.stringForm = stringBuffer.toString();
        return this.stringForm;
    }

    @Override
    public String derefToString() {
        StringBuffer stringBuffer = new StringBuffer(this.functor.name());
        if (this.functor.arity() != 0) {
            stringBuffer.append("(");
            for (int i = 1; i <= this.functor.arity(); ++i) {
                stringBuffer.append(this.argument(i).derefToString() + (i == this.functor.arity() ? ")" : ","));
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equal(FirstOrderTerm firstOrderTerm) {
        boolean bl;
        if (this == firstOrderTerm) {
            return true;
        }
        if (firstOrderTerm.isVariable()) {
            return false;
        }
        FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm;
        int n = 0;
        for (bl = this.functor.equal(firstOrderTermStructure.functor()); bl && ++n <= this.functor.arity(); bl &= this.argument(n).equal(firstOrderTermStructure.argument(n))) {
        }
        return bl;
    }
}

