/*
 * Decompiled with CFR 0.152.
 */
package hlt.fot;

import hlt.fot.BadFunctorArityException;
import hlt.fot.Functor;
import hlt.language.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Signature {
    protected int size = 0;
    protected ArrayList functors;
    protected HashMap functorNameTable;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ArrayList functors() {
        if (this.functors == null) {
            this.functors = new ArrayList();
            return this.functors;
        }
        return this.functors;
    }

    public Functor functor(int n) {
        return (Functor)this.functors().get(n - 1);
    }

    protected HashMap functorNameTable() {
        if (this.functorNameTable == null) {
            this.functorNameTable = new HashMap();
            return this.functorNameTable;
        }
        return this.functorNameTable;
    }

    public void clear() {
        this.functors.clear();
        this.functorNameTable.clear();
    }

    public Functor functor(String string) {
        return (Functor)this.functorNameTable().get(string);
    }

    public Functor functor(String string, int n) {
        Functor functor = (Functor)this.functorNameTable().get(string);
        if (functor == null) {
            functor = new Functor(this.size++, string, n, this);
            this.functors().add(functor);
            this.functorNameTable().put(string, functor);
        } else if (n != functor.arity()) {
            throw new BadFunctorArityException(functor, n);
        }
        return functor;
    }

    public Iterator iterator() {
        return this.functors().iterator();
    }

    public String toString() {
        return this.setForm();
    }

    protected String setForm() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i = 0; i < this.size; ++i) {
            Functor functor = (Functor)this.functors().get(i);
            stringBuilder.append(functor + "/" + functor.arity() + (i < this.size - 1 ? ", " : ""));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

