/*
 * Decompiled with CFR 0.152.
 */
package hlt.fot;

import hlt.fot.FirstOrderTerm;
import hlt.fot.FirstOrderTermStructure;
import java.util.ArrayList;
import java.util.HashMap;

public class Variable
implements FirstOrderTerm {
    private String name;
    private boolean isAnonymous = false;
    public static HashMap registeredVariableTable = new HashMap();
    public static ArrayList registeredVariableNames = new ArrayList();
    private static int anomymousVarCount = 0;
    private FirstOrderTerm deref = this;

    public String name() {
        return this.name;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    private Variable() {
        this(Variable.anonymousVariableName(), true);
    }

    private Variable(String string) {
        this.name = string;
        registeredVariableNames.add(string);
        registeredVariableTable.put(string, this);
    }

    private Variable(String string, boolean bl) {
        this(string);
        this.isAnonymous = bl;
    }

    @Override
    public final boolean isVariable() {
        return true;
    }

    public boolean occursIn(FirstOrderTerm firstOrderTerm) {
        if (firstOrderTerm.isVariable()) {
            return this == ((Variable)firstOrderTerm).deref();
        }
        FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm;
        for (int i = 1; i <= firstOrderTermStructure.functor().arity(); ++i) {
            if (!this.occursIn(firstOrderTermStructure.argument(i))) continue;
            return true;
        }
        return false;
    }

    public static Variable getVariable(String string) {
        Variable variable = (Variable)registeredVariableTable.get(string);
        if (variable == null) {
            variable = new Variable(string);
        }
        return variable;
    }

    public static void resetRegisteredVariables() {
        registeredVariableNames.clear();
        registeredVariableTable.clear();
        anomymousVarCount = 0;
    }

    private static String anonymousVariableName() {
        return "_" + anomymousVarCount++;
    }

    public static Variable anonymousVariable() {
        return new Variable(Variable.anonymousVariableName(), true);
    }

    @Override
    public FirstOrderTerm deref() {
        if (this.deref == this) {
            return this;
        }
        if (this.deref.isVariable()) {
            return ((Variable)this.deref).deref();
        }
        return this.deref;
    }

    public boolean isBound() {
        return this.deref() != this;
    }

    public boolean isUnbound() {
        return this.deref() == this;
    }

    public void bind(FirstOrderTerm firstOrderTerm) {
        this.deref = firstOrderTerm;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String derefToString() {
        FirstOrderTerm firstOrderTerm = this.deref();
        if (firstOrderTerm.isVariable()) {
            return firstOrderTerm.toString();
        }
        return firstOrderTerm.derefToString();
    }

    @Override
    public boolean equal(FirstOrderTerm firstOrderTerm) {
        return this == firstOrderTerm;
    }
}

