/*
 * Decompiled with CFR 0.152.
 */
package hlt.fot.fuz;

import hlt.fot.Functor;
import hlt.fot.fuz.ArgumentPositionMaps;
import hlt.fot.fuz.BadArgumentPositionMappingException;
import hlt.fot.fuz.SignatureSimilarity;
import hlt.fot.fuz.SimilarFunctorSignature;
import hlt.language.util.ArrayList;
import hlt.language.util.IntArrayList;
import hlt.language.util.SetOf;

public class ArgumentPositionMapping {
    private double degree;
    private ArgumentPositionMaps positionMaps;
    private int mappingIndex;
    private int degreeIndex;
    private Functor from;
    private ArrayList domainPositions;
    private SetOf fullDomainPositions;
    private SetOf domain;
    private Functor to;
    private ArrayList rangePositions;
    private SetOf fullRangePositions;
    private SetOf range;
    private int[] mapping;
    private int[] inverse;

    public double degree() {
        return this.degree;
    }

    public ArgumentPositionMaps positionMaps() {
        return this.positionMaps;
    }

    public int mappingIndex() {
        return this.mappingIndex;
    }

    public void setMappingIndex(int n) {
        this.mappingIndex = n;
    }

    public int degreeIndex() {
        return this.degreeIndex;
    }

    public SignatureSimilarity similarity() {
        return this.positionMaps.similarity();
    }

    public SimilarFunctorSignature signature() {
        return this.similarity().signature();
    }

    public Functor from() {
        return this.from;
    }

    public SetOf domain() {
        if (this.domain != null) {
            return this.domain;
        }
        if (this.from.arity() == 0) {
            return null;
        }
        this.domain = new SetOf(this.domainPositions);
        for (int i = 0; i < Math.min(this.from.arity(), this.to.arity()); ++i) {
            this.domain.add(this.domainPositions.get(i));
        }
        return this.domain;
    }

    public SetOf setDomain(SetOf setOf) {
        this.domain = this.verifiedDomain(setOf);
        return this.domain;
    }

    public SetOf verifiedDomain(SetOf setOf) {
        if (!setOf.isSubsetOf(this.fullDomainPositions) || setOf.size() > Math.min(this.from.arity(), this.to.arity())) {
            throw new BadArgumentPositionMappingException("fuzzy degree: " + this.degree + ", from: " + this.from + ", to: " + this.to + "; argument position map's domain " + setOf + " should be a subset of " + this.fullDomainPositions + " and not exceed " + Math.min(this.from.arity(), this.to.arity()));
        }
        return setOf;
    }

    public Functor to() {
        return this.to;
    }

    public SetOf range() {
        if (this.range != null) {
            return this.range;
        }
        if (this.from.arity() == 0) {
            return null;
        }
        this.range = new SetOf(this.rangePositions);
        for (int i = 0; i < Math.min(this.from.arity(), this.to.arity()); ++i) {
            this.range.add(this.rangePositions.get(i));
        }
        return this.range;
    }

    public SetOf setRange(SetOf setOf) {
        this.range = this.verifiedRange(setOf);
        return this.range;
    }

    public SetOf verifiedRange(SetOf setOf) {
        if (!setOf.isSubsetOf(this.fullRangePositions) || setOf.size() > Math.min(this.from.arity(), this.to.arity())) {
            throw new BadArgumentPositionMappingException("fuzzy degree: " + this.degree + ", from: " + this.from + ", to: " + this.to + "; argument position map's range " + setOf + " should be a subset of " + this.fullRangePositions + " and not exceed " + Math.min(this.from.arity(), this.to.arity()));
        }
        return setOf;
    }

    public boolean isEmpty() {
        return this.mapping == null;
    }

    public int size() {
        return this.isEmpty() ? 0 : this.mapping.length;
    }

    public ArgumentPositionMapping(ArgumentPositionMaps argumentPositionMaps, int n, Functor functor, Functor functor2, IntArrayList intArrayList) {
        this.positionMaps = argumentPositionMaps;
        this.degreeIndex = n;
        this.degree = argumentPositionMaps.degrees().get(this.degreeIndex);
        this.from = functor;
        this.to = functor2;
        int n2 = functor.arity();
        int n3 = functor2.arity();
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        this.domainPositions = Functor.argumentList(n2);
        this.rangePositions = Functor.argumentList(n3);
        this.domain = new SetOf(this.domainPositions);
        this.range = new SetOf(this.rangePositions);
        if (intArrayList == null) {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                Integer n7 = n6 + 1;
                this.domain.add(n7);
                this.range.add(n7);
            }
            if (n4 > 0) {
                this.mapping = new int[n4];
                this.inverse = new int[n4];
                for (n6 = 0; n6 < n4; ++n6) {
                    this.mapping[n6] = this.inverse[n6] = n6 + 1;
                }
            }
        } else {
            int n8 = intArrayList.size() / 2;
            this.mapping = new int[n8];
            this.inverse = new int[n8];
            for (int i = 0; i < n8; ++i) {
                this.mapping[i] = intArrayList.get(2 * i);
                this.domain.add((Object)this.mapping[i]);
                this.inverse[i] = intArrayList.get(2 * i + 1);
                this.range.add((Object)this.inverse[i]);
            }
            if (this.domain.size() > n2) {
                throw new BadArgumentPositionMappingException("fuzzy degree: " + this.degree + ", from: " + functor + ", to: " + functor2 + "; mapping domain too large for functor " + functor + "/" + n2 + ": " + this.domain);
            }
            if (this.range.size() > n3) {
                throw new BadArgumentPositionMappingException("fuzzy degree: " + this.degree + ", from: " + functor + ", to: " + functor2 + "; mapping range too large for functor " + functor2 + "/" + n3 + ": " + this.range);
            }
            if (this.domain.size() != this.range.size()) {
                throw new BadArgumentPositionMappingException("fuzzy degree: " + this.degree + ", from: " + functor + ", to: " + functor2 + "; non one-one argument-position mapping from :" + this.domain + " to " + this.range);
            }
        }
    }
}

