/*
 * Decompiled with CFR 0.152.
 */
package hlt.fot.fuz;

import hlt.fot.FirstOrderTerm;
import hlt.fot.FirstOrderTermStructure;
import hlt.fot.Functor;
import hlt.fot.Variable;
import hlt.fot.fuz.FuzzyFirstOrderTerm;
import hlt.fot.fuz.FuzzyFirstOrderTermPair;
import hlt.fot.fuz.SimilarFunctorSignature;
import hlt.language.util.SetOf;
import hlt.language.util.Stack;
import hlt.math.fuzzy.FuzzyMatrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SignatureSimilarity
extends FuzzyMatrix {
    private SimilarFunctorSignature signature;
    private ArrayList similarityClasses;
    private SetOf fullSignatureClass;
    private SetOf[] fullSignaturePartition;
    private SetOf[][] partitions;
    private Functor[][] functorReps;
    static Stack unifyStack = new Stack();
    public static ArrayList generatedVariables = new ArrayList();
    public static HashMap lSubstitution = new HashMap();
    public static HashMap rSubstitution = new HashMap();
    private static int tracingIndent = 3;
    private static String tracingIndentMargin = "";
    private static boolean tracing = false;
    private static final int maxTracingVerbosity = 3;
    private static int tracingVerbosity = 0;

    public SimilarFunctorSignature signature() {
        return this.signature;
    }

    public Functor functor(int n) {
        return this.signature.functor(n);
    }

    public Functor functor(String string) {
        return this.signature.functor(string);
    }

    private SetOf fullSignatureClass() {
        if (this.fullSignatureClass != null) {
            return this.fullSignatureClass;
        }
        this.fullSignatureClass = new SetOf(this.signature.functors());
        for (int i = 1; i <= this.signature.size(); ++i) {
            this.fullSignatureClass.add(this.signature.functor(i));
        }
        SignatureSimilarity.sayIfTracing(3, "recording full signature class " + this.fullSignatureClass + " in classes " + this.similarityClasses);
        this.similarityClasses.add(this.fullSignatureClass);
        SignatureSimilarity.sayIfTracing(3, "now classes = " + this.similarityClasses);
        return this.fullSignatureClass;
    }

    private SetOf canonicalClass(SetOf setOf) {
        int n = this.similarityClasses.indexOf(setOf);
        if (n != -1) {
            SignatureSimilarity.sayIfTracing(2, "found canonical class for " + setOf + " in known classes " + this.similarityClasses + " at index " + n + ": " + (SetOf)this.similarityClasses.get(n));
            return (SetOf)this.similarityClasses.get(n);
        }
        SignatureSimilarity.sayIfTracing(2, "recording it as a new signature class " + setOf + " in classes " + this.similarityClasses);
        this.similarityClasses.add(setOf);
        SignatureSimilarity.sayIfTracing(2, "now classes = " + this.similarityClasses);
        return setOf;
    }

    public SignatureSimilarity(SimilarFunctorSignature similarFunctorSignature, double[][] dArray) {
        super(dArray);
        this.signature = similarFunctorSignature;
        similarFunctorSignature.setSimilarity(this);
        this.similarityClasses = new ArrayList();
        this.i_similarity_closure();
        this.computeDegrees();
    }

    private SetOf[] fullSignaturePartition() {
        if (this.fullSignaturePartition != null) {
            return this.fullSignaturePartition;
        }
        this.fullSignaturePartition = new SetOf[this.signature.size()];
        for (int i = 0; i < this.fullSignaturePartition.length; ++i) {
            this.fullSignaturePartition[i] = this.fullSignatureClass();
        }
        return this.fullSignaturePartition;
    }

    public SetOf[][] partitions() {
        if (this.partitions == null) {
            this.partitions = new SetOf[this.degrees.size()][];
        }
        return this.partitions;
    }

    public SetOf[] getPartition(double d) {
        return this.getPartition(this.getDegreeIndex(d));
    }

    public SetOf[] getPartition(int n) {
        if (this.partitions()[n] != null) {
            return this.partitions[n];
        }
        SignatureSimilarity.sayIfTracing(3, "partitioning for index " + n + " corresponding to degree " + this.degrees.elementAt(n));
        this.partitions[n] = this.partition(n);
        return this.partitions[n];
    }

    public String partitionToString(SetOf[] setOfArray) {
        ArrayList<SetOf> arrayList = new ArrayList<SetOf>();
        StringBuffer stringBuffer = new StringBuffer("{ ");
        for (int i = 0; i < setOfArray.length; ++i) {
            if (arrayList.contains(setOfArray[i])) continue;
            stringBuffer.append((i == 0 ? "" : ", ") + setOfArray[i]);
            arrayList.add(setOfArray[i]);
        }
        return stringBuffer.append(" }").toString();
    }

    private SetOf[] partition(int n) {
        int n2;
        if (n == 0) {
            return this.fullSignaturePartition();
        }
        double d = this.degrees.get(n);
        SetOf[] setOfArray = new SetOf[this.signature.size()];
        SignatureSimilarity.sayIfTracing(3, "created an array of similarity classes for " + this.signature.size() + " functors: " + this.signature.functors() + " at approximation degree " + d + " (degreeIndex " + n + ")");
        for (n2 = 1; n2 <= this.signature.size(); ++n2) {
            SetOf setOf = new SetOf(this.signature.functors());
            for (int i = 1; i <= this.signature.size(); ++i) {
                if (!(this.similarityDegree(this.functor(n2), this.functor(i)) >= d)) continue;
                setOf.add(this.functor(i));
            }
            SignatureSimilarity.sayIfTracing(3, "");
            SignatureSimilarity.sayIfTracing(3, "computed class of functor " + this.functor(n2) + ": " + setOf);
            setOfArray[n2 - 1] = setOf = this.canonicalClass(setOf);
        }
        SignatureSimilarity.sayIfTracing(3, "partition(" + d + ") :");
        if (tracing) {
            for (n2 = 0; n2 < setOfArray.length; ++n2) {
                SignatureSimilarity.sayIfTracing(3, "@@@ the set of functors " + d + "-similar to " + this.functor(n2 + 1) + " is " + setOfArray[n2]);
            }
        }
        return setOfArray;
    }

    public int getDegreeIndex(double d) {
        boolean bl = false;
        int n = this.degrees.size();
        double d2 = 1.0;
        while (!bl && --n >= 0) {
            bl = this.degrees.elementAt(n) <= d;
        }
        if (!bl) {
            SignatureSimilarity.sayIfTracing(1, "no degree in this similarity is <= " + d);
        }
        return n;
    }

    public Functor functorRep(Functor functor, double d) {
        return this.functorRep(functor, this.getDegreeIndex(d));
    }

    private Functor functorRep(Functor functor, int n) {
        if (this.functorReps == null) {
            this.functorReps = new Functor[this.signature().size()][this.degrees.size()];
        }
        Functor functor2 = functor;
        Iterator iterator = this.functorClass(functor, n).iterator();
        while (iterator.hasNext()) {
            Functor functor3 = (Functor)iterator.next();
            if (functor3.arity() < functor2.arity()) {
                functor2 = functor3;
                continue;
            }
            if (functor3.arity() != functor2.arity() || functor3.index() > functor2.index()) continue;
            functor2 = functor3;
        }
        Functor functor4 = functor2;
        this.functorReps[functor.index()][n] = functor4;
        return functor4;
    }

    public SetOf functorClass(Functor functor, double d) {
        return this.getPartition(d)[functor.index()];
    }

    public SetOf functorClass(Functor functor, int n) {
        return this.getPartition(n)[functor.index()];
    }

    public FirstOrderTerm termRep(FirstOrderTerm firstOrderTerm, double d) {
        return this.termRep(firstOrderTerm.deref(), this.getDegreeIndex(d));
    }

    private FirstOrderTerm termRep(FirstOrderTerm firstOrderTerm, int n) {
        if (firstOrderTerm.isVariable()) {
            return firstOrderTerm;
        }
        FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm;
        Functor functor = this.functorRep(firstOrderTermStructure.functor(), n);
        if (firstOrderTermStructure.isConstant()) {
            return new FirstOrderTermStructure(functor);
        }
        FirstOrderTerm[] firstOrderTermArray = new FirstOrderTerm[functor.arity()];
        int n2 = Math.min(firstOrderTermStructure.functor().arity(), functor.arity());
        for (int i = 0; i < n2; ++i) {
            firstOrderTermArray[i] = this.termRep(firstOrderTermStructure.arguments()[i], n);
        }
        return new FirstOrderTermStructure(functor, firstOrderTermArray);
    }

    public ArrayList termClass(FirstOrderTerm firstOrderTerm, double d) {
        return this.termClass(firstOrderTerm.deref(), this.getDegreeIndex(d));
    }

    private ArrayList termClass(FirstOrderTerm firstOrderTerm, int n) {
        SignatureSimilarity.sayIfTracing("computing the similarity class of term " + firstOrderTerm + " at degree index " + n);
        ArrayList<FirstOrderTerm> arrayList = new ArrayList<FirstOrderTerm>();
        if (firstOrderTerm.isVariable()) {
            arrayList.add(firstOrderTerm);
            return arrayList;
        }
        FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm;
        SetOf setOf = this.functorClass(firstOrderTermStructure.functor(), n);
        Iterator iterator = setOf.iterator();
        while (iterator.hasNext()) {
            Functor functor = (Functor)iterator.next();
            if (functor.arity() == 0) {
                arrayList.add(new FirstOrderTermStructure(functor));
                continue;
            }
            ArrayList[] arrayListArray = new ArrayList[functor.arity()];
            SignatureSimilarity.increaseTracingMargin(" of term " + firstOrderTermStructure);
            for (int i = 1; i <= functor.arity(); ++i) {
                arrayListArray[i - 1] = i <= firstOrderTermStructure.functor().arity() ? this.termClass(firstOrderTermStructure.argument(i), n) : this.termClass((FirstOrderTerm)Variable.anonymousVariable(), n);
            }
            SignatureSimilarity.decreaseTracingMargin(" of term " + firstOrderTermStructure);
            int[] nArray = new int[functor.arity()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
            do {
                FirstOrderTerm[] firstOrderTermArray = new FirstOrderTerm[functor.arity()];
                for (int i = 0; i < functor.arity(); ++i) {
                    firstOrderTermArray[i] = i < Math.min(functor.arity(), firstOrderTermStructure.functor().arity()) ? (FirstOrderTerm)arrayListArray[i].get(nArray[i]) : Variable.anonymousVariable();
                }
                arrayList.add(new FirstOrderTermStructure(functor, firstOrderTermArray));
            } while (this.moreArguments(nArray, arrayListArray));
        }
        return arrayList;
    }

    private boolean moreArguments(int[] nArray, ArrayList[] arrayListArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] < arrayListArray[i].size() - 1) {
                int n = i;
                nArray[n] = nArray[n] + 1;
                return true;
            }
            while (i >= 0 && nArray[i] == arrayListArray[i].size() - 1) {
                nArray[i--] = 0;
            }
            if (i < 0) continue;
            int n = i;
            nArray[n] = nArray[n] + 1;
            return true;
        }
        return false;
    }

    public double similarityDegree(Functor functor, Functor functor2) {
        return this.data[functor.index()][functor2.index()];
    }

    public double similarityDegree(FirstOrderTerm firstOrderTerm, FirstOrderTerm firstOrderTerm2) {
        SignatureSimilarity.sayIfTracing(2, tracingIndentMargin + "computing similarity degree of " + firstOrderTerm + " and " + firstOrderTerm2);
        if (firstOrderTerm == firstOrderTerm2) {
            SignatureSimilarity.sayIfTracing(2, tracingIndentMargin + "results in 1.0");
            return 1.0;
        }
        if (firstOrderTerm != firstOrderTerm2 && (firstOrderTerm.isVariable() || firstOrderTerm2.isVariable())) {
            SignatureSimilarity.sayIfTracing(2, tracingIndentMargin + "results in 0.0");
            return 0.0;
        }
        FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm;
        FirstOrderTermStructure firstOrderTermStructure2 = (FirstOrderTermStructure)firstOrderTerm2;
        double d = this.similarityDegree(firstOrderTermStructure.functor(), firstOrderTermStructure2.functor());
        int n = Math.min(firstOrderTermStructure.functor().arity(), firstOrderTermStructure2.functor().arity());
        for (int i = 1; d > 0.0 && i <= n; ++i) {
            d = SignatureSimilarity.inf(d, this.similarityDegree(firstOrderTermStructure.argument(i), firstOrderTermStructure2.argument(i)));
        }
        SignatureSimilarity.sayIfTracing(2, tracingIndentMargin + "results in " + d);
        return d;
    }

    int positionMapping(Functor functor, Functor functor2, double d, int n) {
        return n;
    }

    public double unify(FirstOrderTerm firstOrderTerm, FirstOrderTerm firstOrderTerm2) {
        unifyStack.clear();
        unifyStack.push(firstOrderTerm);
        unifyStack.push(firstOrderTerm2);
        double d = 1.0;
        while (d > 0.0 && !unifyStack.isEmpty()) {
            FirstOrderTerm firstOrderTerm3;
            firstOrderTerm = (FirstOrderTerm)unifyStack.pop();
            firstOrderTerm2 = (FirstOrderTerm)unifyStack.pop();
            if (firstOrderTerm.isVariable()) {
                firstOrderTerm = ((Variable)firstOrderTerm).deref();
            }
            if (firstOrderTerm2.isVariable()) {
                firstOrderTerm2 = ((Variable)firstOrderTerm2).deref();
            }
            if (firstOrderTerm == firstOrderTerm2) continue;
            if (firstOrderTerm.isVariable()) {
                firstOrderTerm3 = (Variable)firstOrderTerm;
                if (((Variable)firstOrderTerm3).occursIn(firstOrderTerm2)) {
                    d = 0.0;
                    continue;
                }
                ((Variable)firstOrderTerm3).bind(firstOrderTerm2);
                continue;
            }
            if (firstOrderTerm2.isVariable()) {
                firstOrderTerm3 = (Variable)firstOrderTerm2;
                if (((Variable)firstOrderTerm3).occursIn(firstOrderTerm)) {
                    d = 0.0;
                    continue;
                }
                ((Variable)firstOrderTerm3).bind(firstOrderTerm);
                continue;
            }
            firstOrderTerm3 = (FirstOrderTermStructure)firstOrderTerm;
            FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm2;
            if (!((d = SignatureSimilarity.inf(d, this.similarityDegree(((FirstOrderTermStructure)firstOrderTerm3).functor(), firstOrderTermStructure.functor()))) > 0.0)) continue;
            int n = Math.min(((FirstOrderTermStructure)firstOrderTerm3).functor().arity(), firstOrderTermStructure.functor().arity());
            for (int i = 1; i <= n; ++i) {
                int n2 = this.positionMapping(((FirstOrderTermStructure)firstOrderTerm3).functor(), firstOrderTermStructure.functor(), d, i);
                unifyStack.push(((FirstOrderTermStructure)firstOrderTerm3).argument(i));
                unifyStack.push(firstOrderTermStructure.argument(n2));
            }
        }
        return d;
    }

    public FuzzyFirstOrderTerm generalize(FirstOrderTerm firstOrderTerm, FirstOrderTerm firstOrderTerm2, double d) {
        if (firstOrderTerm.isVariable() && firstOrderTerm == firstOrderTerm2) {
            return new FuzzyFirstOrderTerm(firstOrderTerm, d);
        }
        if ((firstOrderTerm.isVariable() || firstOrderTerm2.isVariable()) && !firstOrderTerm.equal(firstOrderTerm2)) {
            Variable variable = Variable.anonymousVariable();
            lSubstitution.put(variable, firstOrderTerm);
            rSubstitution.put(variable, firstOrderTerm2);
            generatedVariables.add(variable);
            return new FuzzyFirstOrderTerm(variable, d);
        }
        FirstOrderTermStructure firstOrderTermStructure = (FirstOrderTermStructure)firstOrderTerm;
        FirstOrderTermStructure firstOrderTermStructure2 = (FirstOrderTermStructure)firstOrderTerm2;
        if (this.similarityDegree(firstOrderTermStructure.functor(), firstOrderTermStructure2.functor()) == 0.0) {
            Variable variable = Variable.anonymousVariable();
            lSubstitution.put(variable, firstOrderTerm);
            rSubstitution.put(variable, firstOrderTerm2);
            generatedVariables.add(variable);
            return new FuzzyFirstOrderTerm(variable, d);
        }
        Functor functor = firstOrderTermStructure.functor();
        Functor functor2 = firstOrderTermStructure2.functor();
        int n = functor.arity();
        int n2 = functor2.arity();
        int n3 = Math.min(n, n2);
        Functor functor3 = n <= n2 ? functor : functor2;
        double d2 = this.similarityDegree(functor, functor2);
        SignatureSimilarity.sayIfTracing(1, "generalizing lhs term " + firstOrderTermStructure + " and rhs term " + firstOrderTermStructure2 + " at degree " + d);
        double d3 = SignatureSimilarity.inf(d, d2);
        if (d2 < d) {
            SignatureSimilarity.sayIfTracing(1, "since " + functor + " ~ " + functor2 + " [" + d2 + "] the new generalization degree is now " + d3);
        }
        if (n3 == 0) {
            return new FuzzyFirstOrderTerm(new FirstOrderTermStructure(functor3), d3);
        }
        FirstOrderTermStructure firstOrderTermStructure3 = new FirstOrderTermStructure(functor3, new FirstOrderTerm[n3]);
        SignatureSimilarity.increaseTracingMargin(" of a term with functor " + functor3 + "/" + functor3.arity());
        for (int i = 1; i <= n3; ++i) {
            SignatureSimilarity.sayIfTracing(2, "argument " + i);
            int n4 = this.positionMapping(firstOrderTermStructure.functor(), firstOrderTermStructure2.functor(), d3, i);
            FuzzyFirstOrderTermPair fuzzyFirstOrderTermPair = this.unapply(firstOrderTermStructure.argument(i), firstOrderTermStructure2.argument(n4), d3);
            FuzzyFirstOrderTerm fuzzyFirstOrderTerm = this.generalize(fuzzyFirstOrderTermPair.left(), fuzzyFirstOrderTermPair.right(), fuzzyFirstOrderTermPair.degree());
            firstOrderTermStructure3.setArgument(i, fuzzyFirstOrderTerm.term());
            d3 = fuzzyFirstOrderTerm.degree();
        }
        SignatureSimilarity.decreaseTracingMargin(" of " + firstOrderTermStructure3);
        return new FuzzyFirstOrderTerm(firstOrderTermStructure3, d3);
    }

    public static void resetGeneralizer() {
        generatedVariables.clear();
        lSubstitution.clear();
        rSubstitution.clear();
    }

    private FuzzyFirstOrderTermPair unapply(FirstOrderTerm firstOrderTerm, FirstOrderTerm firstOrderTerm2, double d) {
        SignatureSimilarity.sayIfTracing(2, "unapplying left substitution " + lSubstitution + " and right substitution " + rSubstitution + " to lhs term " + firstOrderTerm + " and rhs term " + firstOrderTerm2 + " at degree " + d);
        for (int i = 0; i < generatedVariables.size(); ++i) {
            double d2 = d;
            Variable variable = (Variable)generatedVariables.get(i);
            FirstOrderTerm firstOrderTerm3 = (FirstOrderTerm)lSubstitution.get(variable);
            FirstOrderTerm firstOrderTerm4 = (FirstOrderTerm)rSubstitution.get(variable);
            double d3 = this.similarityDegree(firstOrderTerm, firstOrderTerm3);
            SignatureSimilarity.sayIfTracing(2, "the lhs argument " + i + "'s unapplied variable " + variable + " gives term: " + firstOrderTerm3 + " resulting in degree " + d3);
            double d4 = this.similarityDegree(firstOrderTerm2, firstOrderTerm4);
            SignatureSimilarity.sayIfTracing(2, "the rhs argument " + i + "'s unapplied variable " + variable + " gives term: " + firstOrderTerm4 + " resulting in degree " + d4);
            d2 = SignatureSimilarity.inf(d2, SignatureSimilarity.inf(d3, d4));
            SignatureSimilarity.sayIfTracing(2, "so the resulting unapplication degree is " + d2);
            if (!(d2 > 0.0)) continue;
            FuzzyFirstOrderTermPair fuzzyFirstOrderTermPair = new FuzzyFirstOrderTermPair(variable, variable, d2);
            SignatureSimilarity.sayIfTracing(2, "therefore the final unapplied fuzzy pair is " + fuzzyFirstOrderTermPair);
            return fuzzyFirstOrderTermPair;
        }
        FuzzyFirstOrderTermPair fuzzyFirstOrderTermPair = new FuzzyFirstOrderTermPair(firstOrderTerm, firstOrderTerm2, d);
        SignatureSimilarity.sayIfTracing(2, "there is no similar unapplication for " + firstOrderTerm + " and " + firstOrderTerm2 + " at degree " + d);
        SignatureSimilarity.sayIfTracing(2, "the final unapplied fuzzy pair is the original unchanged " + fuzzyFirstOrderTermPair);
        return fuzzyFirstOrderTermPair;
    }

    public static void setTracingIndent(int n) {
        tracingIndent = n;
    }

    public static void increaseTracingMargin(String string) {
        SignatureSimilarity.sayIfTracing("process the arguments" + string);
        for (int i = 0; i < tracingIndent; ++i) {
            tracingIndentMargin = tracingIndentMargin + " ";
        }
    }

    public static void decreaseTracingMargin(String string) {
        if (tracingIndentMargin.length() > 0) {
            tracingIndentMargin = tracingIndentMargin.substring(0, tracingIndentMargin.length() - tracingIndent);
        }
        SignatureSimilarity.sayIfTracing("finished processsing the arguments" + string);
    }

    public static void toggleTracing(int n) {
        SignatureSimilarity.setTracingVerbosity(n);
        tracing = n != 0;
        System.err.println("@@@ tracing in now turned " + (String)(tracing ? "ON at level " + n : "OFF"));
    }

    public static void setTracingVerbosity(int n) {
        tracingVerbosity = Math.max(0, Math.min(n, 3));
    }

    public static void sayIfTracing(String string) {
        SignatureSimilarity.sayIfTracing(tracingVerbosity, string);
    }

    public static void sayIfTracing(int n, String string) {
        if (tracing && n >= tracingVerbosity) {
            System.err.println("@@@ " + tracingIndentMargin + string);
        }
    }
}

