/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Closure;
import hlt.language.design.backend.RuntimeObject;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.types.CodeEntry;

public class Block
implements RuntimeObject {
    protected Instruction[] _code;
    protected int _address;
    protected int _voidArity;
    protected int _intArity;
    protected int _realArity;
    protected int _objectArity;
    protected int _arity;
    protected boolean _dejaVu = false;

    public Block(Instruction[] instructionArray, int n, int n2, int n3, int n4, int n5) {
        this._code = instructionArray;
        this._address = n;
        this._voidArity = n2;
        this._intArity = n3;
        this._realArity = n4;
        this._objectArity = n5;
        this._arity = this._intArity + this._realArity + this._objectArity;
    }

    public final Instruction[] code() {
        return this._code;
    }

    public final int address() {
        return this._address;
    }

    public final int arity() {
        return this._arity;
    }

    public final int trueArity() {
        return this._arity + this._voidArity;
    }

    public final int voidArity() {
        return this._voidArity;
    }

    public final int intArity() {
        return this._intArity;
    }

    public final int realArity() {
        return this._realArity;
    }

    public final int objectArity() {
        return this._objectArity;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Block) || object instanceof Closure) {
            return false;
        }
        Block block = (Block)object;
        return this._address == block.address() && this._intArity == block.intArity() && this._voidArity == block.voidArity() && this._realArity == block.realArity() && this._objectArity == block.objectArity() && (this._code == null ? block.code() == null : this._code == block.code());
    }

    public int hashCode() {
        return 2 * this._address + (this._code == null ? 0 : 3 * this._code.length) + 5 * this._voidArity + 7 * this._intArity + 11 * this._realArity + 13 * this._objectArity;
    }

    public String toString() {
        String string = null;
        if (this._dejaVu) {
            string = "BLOCK(" + CodeEntry.getId(this._code) + "," + this._address + ", ...)";
        } else {
            this._dejaVu = true;
            string = "BLOCK(" + CodeEntry.getId(this._code) + "," + this._address + ",<" + this._voidArity + "," + this._intArity + "," + this._realArity + "," + this._objectArity + ">)";
            this._dejaVu = false;
        }
        return string;
    }
}

