/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Block;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.types.CodeEntry;
import hlt.language.tools.Misc;

public class Closure
extends Block {
    private int[] _intFrame;
    private double[] _realFrame;
    private Object[] _objectFrame;
    private boolean _isExitable = true;

    public final boolean isExitable() {
        return this._isExitable;
    }

    public Closure(Instruction[] instructionArray, int n, int n2, int n3, int n4, int n5, int[] nArray, double[] dArray, Object[] objectArray) {
        super(instructionArray, n, n2, n3, n4, n5);
        this._intFrame = nArray;
        this._realFrame = dArray;
        this._objectFrame = objectArray;
    }

    public Closure(boolean bl, Instruction[] instructionArray, int n, int n2, int n3, int n4, int n5, int[] nArray, double[] dArray, Object[] objectArray) {
        this(instructionArray, n, n2, n3, n4, n5, nArray, dArray, objectArray);
        this._isExitable = bl;
    }

    public final int[] intFrame() {
        return this._intFrame;
    }

    public final double[] realFrame() {
        return this._realFrame;
    }

    public final Object[] objectFrame() {
        return this._objectFrame;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Closure)) {
            return false;
        }
        Closure closure = (Closure)object;
        return this._address == closure.address() && this._voidArity == closure.voidArity() && this._intArity == closure.intArity() && this._realArity == closure.realArity() && this._objectArity == closure.objectArity() && this._isExitable == closure.isExitable() && Misc.equal(this._intFrame, closure.intFrame()) && Misc.equal(this._realFrame, closure.realFrame()) && Misc.equal(this._objectFrame, closure.objectFrame()) && (this._code == null ? closure.code() == null : this._code == closure.code());
    }

    @Override
    public final int hashCode() {
        return 2 * this._address + (this._code == null ? 0 : 3 * this._code.length) + 5 * this._voidArity + 7 * this._intArity + 11 * this._realArity + 13 * this._objectArity + 17 * this._intFrame.length + 19 * this._realFrame.length + 23 * this._objectFrame.length;
    }

    @Override
    public final String toString() {
        String string = null;
        if (this._dejaVu) {
            string = "CLOSURE(" + CodeEntry.getId(this._code) + "," + this._address + ", ...)";
        } else {
            this._dejaVu = true;
            string = "CLOSURE(" + CodeEntry.getId(this._code) + "," + this._address + ",<" + this._voidArity + "," + this._intArity + "," + this._realArity + "," + this._objectArity + ">,<" + Misc.arrayToString(this._intFrame) + "," + Misc.arrayToString(this._realFrame) + "," + Misc.arrayToString(this._objectFrame) + ">)";
            this._dejaVu = false;
        }
        return string;
    }
}

