/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Closure;
import hlt.language.design.backend.DisplayFormManager;
import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntMap;
import hlt.language.design.backend.IntRange;
import hlt.language.design.backend.IntSet;
import hlt.language.design.backend.ObjectInstance;
import hlt.language.design.backend.ObjectMap;
import hlt.language.design.backend.ObjectSet;
import hlt.language.design.backend.RealMap;
import hlt.language.design.backend.RealSet;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeMap;
import hlt.language.design.backend.RuntimeReal;
import hlt.language.design.backend.RuntimeSet;
import hlt.language.design.backend.RuntimeTuple;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.NamedTupleType;
import hlt.language.design.types.SetType;
import hlt.language.design.types.TupleType;
import hlt.language.design.types.Type;
import hlt.language.tools.Misc;
import hlt.language.util.DoubleIterator;
import hlt.language.util.IntIterator;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultDisplayFormManager
implements DisplayFormManager {
    private final HashMap _tags = new HashMap();

    @Override
    public String displayVoid() {
        return "()";
    }

    @Override
    public String typedDisplayForm(int n, Type type) {
        return this.quotedDisplayForm(n, type) + " : " + type;
    }

    @Override
    public String typedDisplayForm(double d) {
        return this.quotedDisplayForm(d) + " : real";
    }

    @Override
    public String typedDisplayForm(Object object, Type type) {
        return this.quotedDisplayForm(object, type) + " : " + type.toQuantifiedString();
    }

    @Override
    public String quotedDisplayForm(int n, Type type) {
        if (type.isBoolean()) {
            return n == 0 ? "false" : "true";
        }
        if (type.isChar()) {
            return "'" + String.valueOf((char)n) + "'";
        }
        return String.valueOf(n);
    }

    @Override
    public String unquotedDisplayForm(int n, Type type) {
        String string = this.quotedDisplayForm(n, type);
        if (type.isChar()) {
            string = Misc.stringify(string);
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public String quotedDisplayForm(double d) {
        return String.valueOf(d);
    }

    @Override
    public String unquotedDisplayForm(double d) {
        return this.quotedDisplayForm(d);
    }

    @Override
    public String unquotedDisplayForm(Object object, Type type) {
        if (type.isString()) {
            return (String)object;
        }
        String string = this.quotedDisplayForm(object, type);
        if (type.isChar()) {
            string = Misc.stringify(string);
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public String quotedDisplayForm(Object object, Type type) {
        type = type.actualType();
        if (object == null) {
            return this._nullDisplayForm(type);
        }
        if (object instanceof Closure) {
            return "<function>";
        }
        if (type == Type.STRING) {
            return "\"" + Misc.stringify((String)object) + "\"";
        }
        if (object instanceof RuntimeInt) {
            return this.quotedDisplayForm(((RuntimeInt)object).value(), type);
        }
        if (object instanceof RuntimeReal) {
            return this.quotedDisplayForm(((RuntimeReal)object).value());
        }
        if (object instanceof RuntimeSet) {
            return this._setDisplayForm((RuntimeSet)object, ((SetType)type).baseType());
        }
        if (object instanceof int[]) {
            return this._intArrayDisplayForm((int[])object, ((ArrayType)type).baseType());
        }
        if (object instanceof double[]) {
            return this._realArrayDisplayForm((double[])object);
        }
        if (object instanceof Object[]) {
            return this._objectArrayDisplayForm((Object[])object, ((ArrayType)type).baseType());
        }
        if (object instanceof RuntimeMap) {
            return this._mapDisplayForm((RuntimeMap)object, ((ArrayType)type).baseType(), ((ArrayType)type).indexSetType().baseType());
        }
        if (object instanceof RuntimeTuple) {
            return this._tupleDisplayForm((RuntimeTuple)object, (TupleType)type);
        }
        if (object instanceof ObjectInstance) {
            return this._objectInstanceDisplayForm((ObjectInstance)object, (ClassType)type);
        }
        return object.toString();
    }

    private final String _nullDisplayForm(Type type) {
        if (type.isVoid()) {
            return this.displayVoid();
        }
        if (type.isInt()) {
            return "0";
        }
        if (type.isReal()) {
            return "0.0";
        }
        if (type.isBoolean()) {
            return "false";
        }
        if (type.isChar()) {
            return "''";
        }
        if (type.isString()) {
            return "\"\"";
        }
        return "null";
    }

    private final String _setDisplayForm(RuntimeSet runtimeSet, Type type) {
        if (runtimeSet instanceof ObjectSet) {
            return this._objectSetDisplayForm((ObjectSet)runtimeSet, type);
        }
        if (runtimeSet instanceof IntSet) {
            return this._intSetDisplayForm((IntSet)runtimeSet, type);
        }
        return this._realSetDisplayForm((RealSet)runtimeSet);
    }

    private final String _objectSetDisplayForm(ObjectSet objectSet, Type type) {
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator iterator = objectSet.orderedIterator();
        while (iterator.hasNext()) {
            stringBuilder.append(this.quotedDisplayForm(iterator.next(), type) + (iterator.hasNext() ? "," : ""));
        }
        return stringBuilder.append("}").toString();
    }

    private final String _intSetDisplayForm(IntSet intSet, Type type) {
        StringBuilder stringBuilder = new StringBuilder("{");
        IntIterator intIterator = intSet.orderedIterator();
        while (intIterator.hasNext()) {
            stringBuilder.append(this.quotedDisplayForm(intIterator.next(), type) + (intIterator.hasNext() ? "," : ""));
        }
        return stringBuilder.append("}").toString();
    }

    private final String _realSetDisplayForm(RealSet realSet) {
        StringBuilder stringBuilder = new StringBuilder("{");
        DoubleIterator doubleIterator = realSet.orderedIterator();
        while (doubleIterator.hasNext()) {
            stringBuilder.append(doubleIterator.next() + (doubleIterator.hasNext() ? "," : ""));
        }
        return stringBuilder.append("}").toString();
    }

    private final String _intArrayDisplayForm(int[] nArray, Type type) {
        StringBuilder stringBuilder = new StringBuilder("#[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(this.quotedDisplayForm(nArray[i], type) + (i < nArray.length - 1 ? "," : ""));
        }
        return stringBuilder.append("]#").toString();
    }

    private final String _realArrayDisplayForm(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder("#[");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(dArray[i] + (i < dArray.length - 1 ? "," : ""));
        }
        return stringBuilder.append("]#").toString();
    }

    private final String _objectArrayDisplayForm(Object[] objectArray, Type type) {
        StringBuilder stringBuilder = new StringBuilder("#[");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(this.quotedDisplayForm(objectArray[i], type) + (i < objectArray.length - 1 ? "," : ""));
        }
        return stringBuilder.append("]#").toString();
    }

    private final String _mapDisplayForm(RuntimeMap runtimeMap, Type type, Type type2) {
        if (type.boxSort() == 1) {
            return this._intMapDisplayForm((IntMap)runtimeMap, type, type2);
        }
        if (type.boxSort() == 2) {
            return this._realMapDisplayForm((RealMap)runtimeMap, type2);
        }
        return this._objectMapDisplayForm((ObjectMap)runtimeMap, type, type2);
    }

    private final String _intMapDisplayForm(IntMap intMap, Type type, Type type2) {
        Indexable indexable = intMap.indexable();
        StringBuilder stringBuilder = new StringBuilder("#[");
        if (indexable instanceof IntRange || indexable instanceof IntSet) {
            IntIterator intIterator = indexable.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                stringBuilder.append(this.quotedDisplayForm(n, type2)).append(":").append(this.quotedDisplayForm(intMap.get(n), type));
                if (!intIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        if (indexable instanceof RealSet) {
            DoubleIterator doubleIterator = indexable.realIterator();
            while (doubleIterator.hasNext()) {
                double d = doubleIterator.next();
                stringBuilder.append(d).append(":").append(this.quotedDisplayForm(intMap.get(d), (Type)Type.INT));
                if (!doubleIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        Iterator iterator = indexable.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuilder.append(this.quotedDisplayForm(e, type2)).append(":").append(this.quotedDisplayForm(intMap.get(e), (Type)Type.INT));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]#").toString();
    }

    private final String _realMapDisplayForm(RealMap realMap, Type type) {
        Indexable indexable = realMap.indexable();
        StringBuilder stringBuilder = new StringBuilder("#[");
        if (indexable instanceof IntRange || indexable instanceof IntSet) {
            IntIterator intIterator = indexable.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                stringBuilder.append(this.quotedDisplayForm(n, type)).append(":").append(this.quotedDisplayForm(realMap.get(n)));
                if (!intIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        if (indexable instanceof RealSet) {
            DoubleIterator doubleIterator = indexable.realIterator();
            while (doubleIterator.hasNext()) {
                double d = doubleIterator.next();
                stringBuilder.append(d).append(":").append(this.quotedDisplayForm(realMap.get(d)));
                if (!doubleIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        Iterator iterator = indexable.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuilder.append(this.quotedDisplayForm(e, type)).append(":").append(this.quotedDisplayForm(realMap.get(e)));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]#").toString();
    }

    private final String _objectMapDisplayForm(ObjectMap objectMap, Type type, Type type2) {
        Indexable indexable = objectMap.indexable();
        StringBuilder stringBuilder = new StringBuilder("#[");
        if (indexable instanceof IntRange || indexable instanceof IntSet) {
            IntIterator intIterator = indexable.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                stringBuilder.append(this.quotedDisplayForm(n, type2)).append(":").append(this.quotedDisplayForm(objectMap.get(n), type));
                if (!intIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        if (indexable instanceof RealSet) {
            DoubleIterator doubleIterator = indexable.realIterator();
            while (doubleIterator.hasNext()) {
                double d = doubleIterator.next();
                stringBuilder.append(d).append(":").append(this.quotedDisplayForm(objectMap.get(d), type));
                if (!doubleIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        Iterator iterator = indexable.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuilder.append(this.quotedDisplayForm(e, type2)).append(":").append(this.quotedDisplayForm(objectMap.get(e), type));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]#").toString();
    }

    private final String _tupleDisplayForm(RuntimeTuple runtimeTuple, TupleType tupleType) {
        if (tupleType instanceof NamedTupleType) {
            return this._namedTupleDisplayForm(runtimeTuple, (NamedTupleType)tupleType);
        }
        StringBuilder stringBuilder = new StringBuilder("<");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = tupleType.dimension();
        for (int i = 0; i < n4; ++i) {
            Type type = tupleType.component(i);
            switch (type.boxSort()) {
                case 1: {
                    stringBuilder.append(this.quotedDisplayForm(runtimeTuple.intComponents()[n++], type));
                    break;
                }
                case 2: {
                    stringBuilder.append(this.quotedDisplayForm(runtimeTuple.realComponents()[n2++]));
                    break;
                }
                default: {
                    stringBuilder.append(this.quotedDisplayForm(runtimeTuple.objectComponents()[n3++], type));
                }
            }
            if (i >= n4 - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append(">").toString();
    }

    private final String _namedTupleDisplayForm(RuntimeTuple runtimeTuple, NamedTupleType namedTupleType) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = namedTupleType.dimension();
        String[] stringArray = new String[n4];
        block4: for (int i = 0; i < n4; ++i) {
            Type type = namedTupleType.component(i);
            switch (type.boxSort()) {
                case 1: {
                    stringArray[i] = this.quotedDisplayForm(runtimeTuple.intComponents()[n++], type);
                    continue block4;
                }
                case 2: {
                    stringArray[i] = this.quotedDisplayForm(runtimeTuple.realComponents()[n2++]);
                    continue block4;
                }
                default: {
                    stringArray[i] = this.quotedDisplayForm(runtimeTuple.objectComponents()[n3++], type);
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder("<");
        for (int i = 0; i < n4; ++i) {
            stringBuilder.append(namedTupleType.fields()[namedTupleType.index()[i]]).append(":=").append(stringArray[namedTupleType.index()[i]]).append(i == n4 - 1 ? "" : ",");
        }
        return stringBuilder.append(">").toString();
    }

    private final String _objectInstanceDisplayForm(ObjectInstance objectInstance, ClassType classType) {
        boolean bl;
        String string = this._getTag(objectInstance);
        boolean bl2 = bl = string != null;
        if (!bl) {
            string = this._putTag(objectInstance);
        }
        StringBuilder stringBuilder = new StringBuilder(classType.name() + string);
        if (!bl) {
            stringBuilder.append("{");
            DefinedEntry[] definedEntryArray = classType.fields();
            if (definedEntryArray.length == 0) {
                return stringBuilder + "}";
            }
            for (int i = 0; i < definedEntryArray.length; ++i) {
                stringBuilder.append(definedEntryArray[i].symbol() + " = " + this._fieldDisplayForm(objectInstance, definedEntryArray[i]) + (i == definedEntryArray.length - 1 ? "}" : ", "));
            }
        }
        return stringBuilder.toString();
    }

    private final String _fieldDisplayForm(ObjectInstance objectInstance, DefinedEntry definedEntry) {
        objectInstance.type().bindArguments();
        Type type = definedEntry.fieldType().copy();
        objectInstance.type().unbindArguments();
        switch (definedEntry.fieldSort()) {
            case 1: {
                return this.quotedDisplayForm(objectInstance.getIntField(definedEntry.fieldOffset()), type);
            }
            case 2: {
                return this.quotedDisplayForm(objectInstance.getRealField(definedEntry.fieldOffset()));
            }
        }
        return this.quotedDisplayForm(objectInstance.getObjectField(definedEntry.fieldOffset()), type);
    }

    @Override
    public DisplayFormManager clearTags() {
        this._tags.clear();
        return this;
    }

    private final String _getTag(ObjectInstance objectInstance) {
        HashMap hashMap = (HashMap)this._tags.get(objectInstance.type());
        if (hashMap == null) {
            hashMap = new HashMap();
            this._tags.put(objectInstance.type(), hashMap);
            return null;
        }
        return (String)hashMap.get(objectInstance);
    }

    private final String _putTag(ObjectInstance objectInstance) {
        HashMap<ObjectInstance, CallSite> hashMap = (HashMap<ObjectInstance, CallSite>)this._tags.get(objectInstance.type());
        if (hashMap == null) {
            hashMap = new HashMap<ObjectInstance, CallSite>();
            this._tags.put(objectInstance.type(), hashMap);
        }
        String string = "#" + hashMap.size();
        hashMap.put(objectInstance, (CallSite)((Object)string));
        return string;
    }
}

