/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IndexableContainer;
import hlt.language.design.backend.IntSet;
import hlt.language.design.backend.Lockable;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeObject;
import hlt.language.util.DoubleIterator;
import hlt.language.util.IntIterator;
import java.util.Iterator;

public class IntRange
implements RuntimeObject,
IndexableContainer,
Lockable {
    private int _lo;
    private int _hi;
    private IntSet _set;

    public IntRange() {
        this._lo = 0;
        this._hi = -1;
    }

    public IntRange(int n, int n2) {
        if (n > n2) {
            this._lo = 0;
            this._hi = -1;
        } else {
            this._lo = n;
            this._hi = n2;
        }
    }

    @Override
    public final boolean isEmpty() {
        return this._lo > this._hi;
    }

    @Override
    public final boolean contains(int n) {
        return this._lo <= n && n <= this._hi;
    }

    @Override
    public final boolean contains(double d) {
        int n = (int)d;
        return this._lo <= n && n <= this._hi;
    }

    @Override
    public final boolean contains(Object object) {
        int n = ((RuntimeInt)object).value();
        return this._lo <= n && n <= this._hi;
    }

    public final int lb() {
        return this._lo;
    }

    public final int ub() {
        return this._hi;
    }

    @Override
    public final int size() {
        return this._hi - this._lo + 1;
    }

    @Override
    public final int getIndex(int n) {
        return n - this._lo;
    }

    @Override
    public final int getIndex(double d) {
        return (int)d - this._lo;
    }

    @Override
    public final int getIndex(Object object) {
        return ((RuntimeInt)object).value() - this._lo;
    }

    @Override
    public final void lock() {
    }

    @Override
    public final void unlock() {
    }

    @Override
    public final boolean isLocked() {
        return true;
    }

    public final IntSet toIntSet() {
        if (this._set != null) {
            return this._set;
        }
        this._set = new IntSet();
        for (int i = this._lo; i <= this._hi; ++i) {
            this._set.add(i);
        }
        return this._set;
    }

    @Override
    public final IntIterator intIterator(boolean bl) {
        return new IntRangeIterator(this._lo, this._hi);
    }

    @Override
    public final IntIterator intIterator() {
        return new IntRangeIterator(this._lo, this._hi);
    }

    @Override
    public final DoubleIterator realIterator(boolean bl) {
        return new RealRangeIterator(this._lo, this._hi);
    }

    @Override
    public final DoubleIterator realIterator() {
        return new RealRangeIterator(this._lo, this._hi);
    }

    @Override
    public final Iterator iterator(boolean bl) {
        return new ObjectRangeIterator(this._lo, this._hi);
    }

    @Override
    public final Iterator iterator() {
        return new ObjectRangeIterator(this._lo, this._hi);
    }

    @Override
    public final IntIterator backwardIntIterator() {
        return new BackwardIntRangeIterator(this._hi, this._lo);
    }

    @Override
    public final DoubleIterator backwardRealIterator() {
        return new BackwardRealRangeIterator(this._hi, this._lo);
    }

    @Override
    public final Iterator backwardIterator() {
        return new BackwardObjectRangeIterator(this._hi, this._lo);
    }

    @Override
    public final IntIterator indexIterator() {
        return new IntRangeIterator(0, this.size() - 1);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IntRange) {
            IntRange intRange = (IntRange)object;
            return intRange.lb() == this._lo && intRange.ub() == this._hi;
        }
        if (object instanceof IntSet) {
            IntSet intSet = (IntSet)object;
            if (this.size() != intSet.size()) {
                return false;
            }
            return this.equals(intSet.toIntRange());
        }
        if (!(object instanceof IndexableContainer)) {
            return false;
        }
        IndexableContainer indexableContainer = (IndexableContainer)object;
        if (this.size() != indexableContainer.size()) {
            return false;
        }
        IntIterator intIterator = this.intIterator(false);
        while (intIterator.hasNext()) {
            if (indexableContainer.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object object, int[] nArray) {
        if (this == object) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return true;
        }
        if (!(object instanceof Indexable)) {
            return false;
        }
        Indexable indexable = (Indexable)object;
        if (this.size() != indexable.size()) {
            return false;
        }
        for (int i = this._lo; i <= this._hi; ++i) {
            int n = indexable.getIndex(i);
            if (n == -1) {
                return false;
            }
            nArray[n] = i - this._lo;
        }
        return true;
    }

    public final String toString() {
        return this.isEmpty() ? "<empty int range>" : this._lo + " .. " + this._hi;
    }

    private static class BackwardRealRangeIterator
    implements DoubleIterator {
        private BackwardIntRangeIterator _intIterator;

        public BackwardRealRangeIterator(int n, int n2) {
            this._intIterator = new BackwardIntRangeIterator(n, n2);
        }

        @Override
        public final boolean hasNext() {
            return this._intIterator.hasNext();
        }

        @Override
        public final double next() {
            return this._intIterator.next();
        }
    }

    private static class RealRangeIterator
    implements DoubleIterator {
        private IntRangeIterator _intIterator;

        public RealRangeIterator(int n, int n2) {
            this._intIterator = new IntRangeIterator(n, n2);
        }

        @Override
        public final boolean hasNext() {
            return this._intIterator.hasNext();
        }

        @Override
        public final double next() {
            return this._intIterator.next();
        }
    }

    private static class BackwardObjectRangeIterator
    implements Iterator {
        private BackwardIntRangeIterator _intIterator;

        public BackwardObjectRangeIterator(int n, int n2) {
            this._intIterator = new BackwardIntRangeIterator(n, n2);
        }

        @Override
        public final boolean hasNext() {
            return this._intIterator.hasNext();
        }

        public final Object next() {
            return Runtime.newInt(this._intIterator.next());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ObjectRangeIterator
    implements Iterator {
        private IntRangeIterator _intIterator;

        public ObjectRangeIterator(int n, int n2) {
            this._intIterator = new IntRangeIterator(n, n2);
        }

        @Override
        public final boolean hasNext() {
            return this._intIterator.hasNext();
        }

        public final Object next() {
            return Runtime.newInt(this._intIterator.next());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BackwardIntRangeIterator
    implements IntIterator {
        private int _current;
        private int _lo;

        public BackwardIntRangeIterator(int n, int n2) {
            this._current = n;
            this._lo = n2;
        }

        @Override
        public final boolean hasNext() {
            return this._current >= this._lo;
        }

        @Override
        public final int next() {
            return this._current--;
        }
    }

    private static class IntRangeIterator
    implements IntIterator {
        private int _current;
        private int _hi;

        public IntRangeIterator(int n, int n2) {
            this._current = n;
            this._hi = n2;
        }

        @Override
        public final boolean hasNext() {
            return this._current <= this._hi;
        }

        @Override
        public final int next() {
            return this._current++;
        }
    }
}

