/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IndexableContainer;
import hlt.language.design.backend.IntRange;
import hlt.language.design.backend.NoSuchElementException;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeSet;
import hlt.language.util.DoubleIterator;
import hlt.language.util.IntIterator;
import hlt.language.util.IntToIntMap;
import hlt.language.util.ToIntMap;
import java.util.Iterator;

public class IntSet
extends RuntimeSet {
    private IntToIntMap _map = new IntToIntMap();
    private int[] _array;
    private IntRange _intRange;
    private int _min = Integer.MAX_VALUE;
    private int _max = Integer.MIN_VALUE;

    public IntSet() {
    }

    private IntSet(IntToIntMap intToIntMap) {
        this._map.include(intToIntMap);
    }

    @Override
    final ToIntMap map() {
        return this._map;
    }

    public final int[] array() {
        block4: {
            if (this._map.size() <= 0 || this._array != null && !this._hasHoles) break block4;
            this._array = new int[this._map.size()];
            if (this._hasHoles) {
                ToIntMap.Entry[] entryArray = this._resetIndices();
                int n = this._array.length;
                while (n-- > 0) {
                    IntToIntMap.Entry entry = (IntToIntMap.Entry)entryArray[n];
                    this._array[entry.value()] = entry.key();
                }
            } else {
                Iterator iterator = this._map.iterator();
                while (iterator.hasNext()) {
                    IntToIntMap.Entry entry = (IntToIntMap.Entry)iterator.next();
                    this._array[entry.value()] = entry.key();
                }
            }
        }
        return this._array;
    }

    @Override
    public final int firstInt() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException((Object)"first element of an empty set");
        }
        return this.array()[0];
    }

    @Override
    public final double firstReal() throws NoSuchElementException {
        return this.firstInt();
    }

    @Override
    public final Object firstObject() throws NoSuchElementException {
        return new RuntimeInt(this.firstInt());
    }

    @Override
    public final int lastInt() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException((Object)"last element of an empty set");
        }
        return this.array()[this.size() - 1];
    }

    @Override
    public final double lastReal() throws NoSuchElementException {
        return this.lastInt();
    }

    @Override
    public final Object lastObject() throws NoSuchElementException {
        return new RuntimeInt(this.lastInt());
    }

    @Override
    public final int ord(int n) throws NoSuchElementException {
        int n2;
        if (this._hasHoles) {
            this._resetIndices();
        }
        if ((n2 = this.getIndex(n)) == -1) {
            throw new NoSuchElementException((Object)(n + " doesn't belong to this set"));
        }
        return n2;
    }

    @Override
    public final int ord(double d) throws NoSuchElementException {
        return this.ord((int)d);
    }

    @Override
    public final int ord(Object object) throws NoSuchElementException {
        return this.ord(((RuntimeInt)object).value());
    }

    @Override
    public final int next(int n) throws NoSuchElementException {
        int n2 = this.ord(n) + 1;
        if (n2 == this.size()) {
            throw new NoSuchElementException((Object)(n + " has no successor in this set"));
        }
        return this.array()[n2];
    }

    @Override
    public final double next(double d) throws NoSuchElementException {
        return this.next((int)d);
    }

    @Override
    public final Object next(Object object) throws NoSuchElementException {
        return new RuntimeInt(this.next(((RuntimeInt)object).value()));
    }

    @Override
    public final int prev(int n) throws NoSuchElementException {
        int n2 = this.ord(n) - 1;
        if (n2 == -1) {
            throw new NoSuchElementException((Object)(n + " has no predecessor in this set"));
        }
        return this.array()[n2];
    }

    @Override
    public final double prev(double d) throws NoSuchElementException {
        return this.prev((int)d);
    }

    @Override
    public final Object prev(Object object) throws NoSuchElementException {
        return new RuntimeInt(this.prev(((RuntimeInt)object).value()));
    }

    @Override
    public final int nextc(int n) throws NoSuchElementException {
        return this.array()[(this.ord(n) + 1) % this.size()];
    }

    @Override
    public final double nextc(double d) throws NoSuchElementException {
        return this.nextc((int)d);
    }

    @Override
    public final Object nextc(Object object) throws NoSuchElementException {
        return new RuntimeInt(this.next(((RuntimeInt)object).value()));
    }

    @Override
    public final int prevc(int n) throws NoSuchElementException {
        return this.array()[(this.ord(n) + this.size() - 1) % this.size()];
    }

    @Override
    public final double prevc(double d) throws NoSuchElementException {
        return this.prevc((int)d);
    }

    @Override
    public final Object prevc(Object object) throws NoSuchElementException {
        return new RuntimeInt(this.prevc(((RuntimeInt)object).value()));
    }

    @Override
    public final RuntimeSet copy() {
        return new IntSet(this._map)._setHasHoles(this._hasHoles)._setMaxIndex(this._maxIndex);
    }

    @Override
    public final int getIndex(int n) {
        int n2 = this._map.get(n);
        return n2 == Integer.MIN_VALUE && !this._map.containsKey(n) ? -1 : n2;
    }

    @Override
    public final int getIndex(double d) {
        return this.getIndex((int)d);
    }

    @Override
    public final int getIndex(Object object) {
        return this.getIndex(((RuntimeInt)object).value());
    }

    public final int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException((Object)"attempt to take the minimum element of an empty set");
        }
        return this._min;
    }

    public final int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException((Object)"attempt to take the maximum element of an empty set");
        }
        return this._max;
    }

    public final void addInt(int n) {
        this.add(n);
    }

    @Override
    protected final RuntimeSet _add(int n) {
        if (!this._map.containsKey(n)) {
            int n2;
            this._map.put(n, this._maxIndex++);
            int n3 = this.size() == 1 ? n : Math.min(this._min, n);
            int n4 = n2 = this.size() == 1 ? n : Math.max(this._max, n);
            if (n3 != this._min || n2 != this._max) {
                this._intRange = null;
            }
            this._array = null;
            this._min = n3;
            this._max = n2;
        }
        return this;
    }

    @Override
    protected final RuntimeSet _add(double d) {
        return this._add((int)d);
    }

    @Override
    protected final RuntimeSet _add(Object object) {
        return this._add(((RuntimeInt)object).value());
    }

    @Override
    protected final RuntimeSet _remove(int n) {
        if (this._hasHoles |= this._map.remove(n) >= 0) {
            if (n == this._min) {
                this._recomputeMin();
            }
            if (n == this._max) {
                this._recomputeMax();
            }
            this._array = null;
        }
        return this;
    }

    @Override
    protected final RuntimeSet _remove(double d) {
        return this._remove((int)d);
    }

    @Override
    protected final RuntimeSet _remove(Object object) {
        return this._remove(((RuntimeInt)object).value());
    }

    @Override
    public final boolean contains(int n) {
        return this._map.containsKey(n);
    }

    @Override
    public final boolean contains(double d) {
        return this._map.containsKey((int)d);
    }

    @Override
    public final boolean contains(Object object) {
        return this._map.containsKey(((RuntimeInt)object).value());
    }

    @Override
    public final boolean contains(RuntimeSet runtimeSet) {
        IntIterator intIterator = runtimeSet.intIterator(false);
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final RuntimeSet _union(RuntimeSet runtimeSet) {
        IntIterator intIterator = runtimeSet.intIterator(true);
        while (intIterator.hasNext()) {
            this._add(intIterator.next());
        }
        return this;
    }

    @Override
    public final RuntimeSet _intersection(RuntimeSet runtimeSet) {
        IntIterator intIterator = this.intIterator(false);
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (runtimeSet.contains(n)) continue;
            this._remove(n);
        }
        return this;
    }

    @Override
    public final RuntimeSet _minus(RuntimeSet runtimeSet) {
        IntIterator intIterator = runtimeSet.intIterator(false);
        while (intIterator.hasNext()) {
            this._remove(intIterator.next());
        }
        return this;
    }

    @Override
    public final RuntimeSet _exclusion(RuntimeSet runtimeSet) {
        IntIterator intIterator = runtimeSet.intIterator(true);
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (this.contains(n)) {
                this._remove(n);
                continue;
            }
            this._add(n);
        }
        return this;
    }

    public final void _recomputeMin() {
        this._min = Integer.MAX_VALUE;
        IntIterator intIterator = this.intIterator(false);
        while (intIterator.hasNext()) {
            this._min = Math.min(this._min, intIterator.next());
        }
        this._intRange = null;
    }

    public final void _recomputeMax() {
        this._max = Integer.MIN_VALUE;
        IntIterator intIterator = this.intIterator(false);
        while (intIterator.hasNext()) {
            this._max = Math.max(this._max, intIterator.next());
        }
        this._intRange = null;
    }

    public final IntRange toIntRange() {
        if (this._intRange != null) {
            return this._intRange;
        }
        this._intRange = this.isEmpty() ? new IntRange() : new IntRange(this._min, this._max);
        return this._intRange;
    }

    @Override
    public final IntIterator intIterator() {
        return this.intIterator(this._isLocked);
    }

    @Override
    public final IntIterator intIterator(boolean bl) {
        return bl ? this.orderedIterator() : this._map.keys();
    }

    @Override
    public final DoubleIterator realIterator(boolean bl) {
        return new RealIterator(this.intIterator(bl));
    }

    @Override
    public final DoubleIterator realIterator() {
        return new RealIterator(this.intIterator());
    }

    @Override
    public final Iterator iterator(boolean bl) {
        return new BoxedIntIterator(this.intIterator(bl));
    }

    @Override
    public final Iterator iterator() {
        return new BoxedIntIterator(this.intIterator());
    }

    public final IntIterator orderedIterator() {
        return new OrderedIterator(this.array());
    }

    @Override
    public final IntIterator backwardIntIterator() {
        return new BackwardIterator(this.array());
    }

    @Override
    public final DoubleIterator backwardRealIterator() {
        return new RealIterator(this.backwardIntIterator());
    }

    @Override
    public final Iterator backwardIterator() {
        return new BoxedIntIterator(this.backwardIntIterator());
    }

    @Override
    public final IntIterator indexIterator() {
        return this._map.values();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexableContainer)) {
            return false;
        }
        IndexableContainer indexableContainer = (IndexableContainer)object;
        if (this.size() != indexableContainer.size()) {
            return false;
        }
        IntIterator intIterator = this.intIterator(false);
        while (intIterator.hasNext()) {
            if (indexableContainer.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object object, int[] nArray) {
        if (this == object) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return true;
        }
        if (!(object instanceof Indexable)) {
            return false;
        }
        Indexable indexable = (Indexable)object;
        if (this.size() != indexable.size()) {
            return false;
        }
        Iterator iterator = this._map.iterator();
        while (iterator.hasNext()) {
            IntToIntMap.Entry entry = (IntToIntMap.Entry)iterator.next();
            int n = indexable.getIndex(entry.key());
            if (n == -1) {
                return false;
            }
            nArray[n] = entry.value();
        }
        return true;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = this.size();
        IntIterator intIterator = this.intIterator(true);
        while (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next()).append(--n == 0 ? "" : ", ");
        }
        return stringBuilder.append("}").toString();
    }

    private static class BackwardIterator
    implements IntIterator {
        private int[] _array;
        private int _index;

        BackwardIterator(int[] nArray) {
            this._array = nArray;
            this._index = this._array.length;
        }

        @Override
        public final boolean hasNext() {
            return this._array == null ? false : this._index > 0;
        }

        @Override
        public final int next() {
            return this._array[--this._index];
        }
    }

    private static class OrderedIterator
    implements IntIterator {
        private int[] _array;
        private int _index = 0;

        OrderedIterator(int[] nArray) {
            this._array = nArray;
        }

        @Override
        public final boolean hasNext() {
            return this._array == null ? false : this._index < this._array.length;
        }

        @Override
        public final int next() {
            return this._array[this._index++];
        }
    }

    private static class RealIterator
    implements DoubleIterator {
        private IntIterator _iterator;

        RealIterator(IntIterator intIterator) {
            this._iterator = intIterator;
        }

        @Override
        public final boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public final double next() {
            return this._iterator.next();
        }
    }

    private static class BoxedIntIterator
    implements Iterator {
        private IntIterator _iterator;

        BoxedIntIterator(IntIterator intIterator) {
            this._iterator = intIterator;
        }

        @Override
        public final boolean hasNext() {
            return this._iterator.hasNext();
        }

        public final Object next() {
            return new RuntimeInt(this._iterator.next());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

