/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.RuntimeObject;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.ObjectInitializationException;
import hlt.language.design.types.Type;
import java.lang.invoke.CallSite;
import java.util.HashMap;

public class ObjectInstance
implements RuntimeObject {
    private ClassType _type;
    private int[] _intFields;
    private double[] _realFields;
    private Object[] _objectFields;
    private static final HashMap _tags = new HashMap();

    public ObjectInstance(ClassType classType) throws ObjectInitializationException {
        if (!classType.isDeclared()) {
            throw new ObjectInitializationException((Object)("undeclared class type: " + classType));
        }
        this._type = classType;
        int n = classType.intFieldsCount();
        int n2 = classType.realFieldsCount();
        int n3 = classType.objectFieldsCount();
        if (n != 0) {
            this._intFields = new int[n];
        }
        if (n2 != 0) {
            this._realFields = new double[n2];
        }
        if (n3 != 0) {
            this._objectFields = new Object[n3];
        }
    }

    public final ClassType type() {
        return this._type;
    }

    public final String getClassName() {
        return this._type.name();
    }

    public final int getIntField(int n) {
        return this._intFields[n];
    }

    public final int setIntField(int n, int n2) {
        this._intFields[n] = n2;
        return this._intFields[n];
    }

    public final double getRealField(int n) {
        return this._realFields[n];
    }

    public final double setRealField(int n, double d) {
        this._realFields[n] = d;
        return this._realFields[n];
    }

    public final Object getObjectField(int n) {
        return this._objectFields[n];
    }

    public final Object setObjectField(int n, Object object) {
        this._objectFields[n] = object;
        return this._objectFields[n];
    }

    public final String toString() {
        ObjectInstance._clearTags();
        return this._toTaggedString();
    }

    private final String _toTaggedString() {
        boolean bl;
        String string = this._getTag();
        boolean bl2 = bl = string != null;
        if (!bl) {
            string = this._putTag();
        }
        StringBuilder stringBuilder = new StringBuilder(this._type.name() + string);
        if (!bl) {
            stringBuilder.append("{");
            DefinedEntry[] definedEntryArray = this._type.fields();
            if (definedEntryArray.length == 0) {
                return stringBuilder + "}";
            }
            for (int i = 0; i < definedEntryArray.length; ++i) {
                stringBuilder.append(definedEntryArray[i].symbol() + " = " + this._fieldStringValueOf(definedEntryArray[i]) + (i == definedEntryArray.length - 1 ? "}" : ", "));
            }
        }
        return stringBuilder.toString();
    }

    private static void _clearTags() {
        _tags.clear();
    }

    private String _getTag() {
        HashMap hashMap = (HashMap)_tags.get(this._type);
        if (hashMap == null) {
            hashMap = new HashMap();
            _tags.put(this._type, hashMap);
            return null;
        }
        return (String)hashMap.get(this);
    }

    private String _putTag() {
        HashMap<ObjectInstance, CallSite> hashMap = (HashMap<ObjectInstance, CallSite>)_tags.get(this._type);
        if (hashMap == null) {
            hashMap = new HashMap<ObjectInstance, CallSite>();
            _tags.put(this._type, hashMap);
        }
        String string = "#" + hashMap.size();
        hashMap.put(this, (CallSite)((Object)string));
        return string;
    }

    private final String _fieldStringValueOf(DefinedEntry definedEntry) {
        switch (definedEntry.fieldSort()) {
            case 1: {
                int n = this.getIntField(definedEntry.fieldOffset());
                Type type = definedEntry.fieldType();
                if (type.isVoid()) {
                    return "()";
                }
                if (type.isBoolean()) {
                    return n == 0 ? "false" : "true";
                }
                if (type.isChar()) {
                    return String.valueOf((char)n);
                }
                return String.valueOf(n);
            }
            case 2: {
                return String.valueOf(this.getRealField(definedEntry.fieldOffset()));
            }
        }
        Object object = this.getObjectField(definedEntry.fieldOffset());
        if (object == null) {
            return "null";
        }
        if (object instanceof ObjectInstance) {
            return ((ObjectInstance)object)._toTaggedString();
        }
        String string = object.toString();
        return string;
    }
}

