/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntRange;
import hlt.language.design.backend.IntSet;
import hlt.language.design.backend.RealSet;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.RuntimeMap;
import hlt.language.util.DoubleIterator;
import hlt.language.util.IntIterator;
import java.util.Iterator;

public class ObjectMap
extends RuntimeMap {
    private Object[] _array;

    public ObjectMap(Object[] objectArray, Indexable indexable) {
        this._array = objectArray;
        this._indexable = indexable;
        this._indexable.lock();
    }

    public final Object[] array() {
        return this._array;
    }

    @Override
    public final RuntimeMap copy() {
        return new ObjectMap(Runtime.copy(this._array), this._indexable);
    }

    @Override
    public final Object extractArray() {
        return this._array;
    }

    public final Object[] toArray() {
        this.trimToSize();
        return this._array;
    }

    @Override
    public final RuntimeMap setArray(Object object) {
        this._array = (Object[])object;
        return this;
    }

    public final Object get(Object object) {
        return this._array[this._indexable.getIndex(object)];
    }

    public final Object get(int n) {
        return this._array[this._indexable.getIndex(n)];
    }

    public final Object get(double d) {
        return this._array[this._indexable.getIndex(d)];
    }

    public final Object set(Object object, Object object2) {
        Object object3 = object2;
        this._array[this._indexable.getIndex((Object)object)] = object3;
        return object3;
    }

    public final Object set(int n, Object object) {
        Object object2 = object;
        this._array[this._indexable.getIndex((int)n)] = object2;
        return object2;
    }

    public final Object set(double d, Object object) {
        Object object2 = object;
        this._array[this._indexable.getIndex((double)d)] = object2;
        return object2;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        return this._array == ((ObjectMap)object).array() && this._indexable.equals(((ObjectMap)object).indexable());
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("#[");
        if (this._indexable instanceof IntRange || this._indexable instanceof IntSet) {
            IntIterator intIterator = this._indexable.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                stringBuilder.append(n).append(":").append(this.get(n));
                if (!intIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        if (this._indexable instanceof RealSet) {
            DoubleIterator doubleIterator = this._indexable.realIterator();
            while (doubleIterator.hasNext()) {
                double d = doubleIterator.next();
                stringBuilder.append(d).append(":").append(this.get(d));
                if (!doubleIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        Iterator iterator = this._indexable.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuilder.append(e).append(":").append(this.get(e));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]#").toString();
    }
}

