/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IndexableContainer;
import hlt.language.design.backend.NoSuchElementException;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeReal;
import hlt.language.design.backend.RuntimeSet;
import hlt.language.design.backend.RuntimeTuple;
import hlt.language.design.backend.Sliceable;
import hlt.language.tools.Misc;
import hlt.language.util.DoubleIterator;
import hlt.language.util.IntIterator;
import hlt.language.util.ObjectToIntMap;
import hlt.language.util.ToIntMap;
import java.util.HashMap;
import java.util.Iterator;

public class ObjectSet
extends RuntimeSet
implements Sliceable {
    private ObjectToIntMap _map = new ObjectToIntMap();
    private Object[] _array;
    private int[] _slice;
    private HashMap _sliceMap;

    public ObjectSet() {
    }

    public ObjectSet(ObjectToIntMap objectToIntMap) {
        this._map.include(objectToIntMap);
    }

    @Override
    final ToIntMap map() {
        return this._map;
    }

    public final Object[] array() {
        block4: {
            if (this._map.size() <= 0 || this._array != null && !this._hasHoles) break block4;
            this._array = new Object[this._map.size()];
            if (this._hasHoles) {
                ToIntMap.Entry[] entryArray = this._resetIndices();
                int n = this._array.length;
                while (n-- > 0) {
                    ObjectToIntMap.Entry entry = (ObjectToIntMap.Entry)entryArray[n];
                    this._array[entry.value()] = entry.key();
                }
            } else {
                Iterator iterator = this._map.iterator();
                while (iterator.hasNext()) {
                    ObjectToIntMap.Entry entry = (ObjectToIntMap.Entry)iterator.next();
                    this._array[entry.value()] = entry.key();
                }
            }
        }
        return this._array;
    }

    @Override
    public final int firstInt() throws NoSuchElementException {
        return ((RuntimeInt)this.firstObject()).value();
    }

    @Override
    public final double firstReal() throws NoSuchElementException {
        return ((RuntimeReal)this.firstObject()).value();
    }

    @Override
    public final Object firstObject() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException((Object)"first element of an empty set");
        }
        return this.array()[0];
    }

    @Override
    public final int lastInt() throws NoSuchElementException {
        return ((RuntimeInt)this.lastObject()).value();
    }

    @Override
    public final double lastReal() throws NoSuchElementException {
        return ((RuntimeReal)this.lastObject()).value();
    }

    @Override
    public final Object lastObject() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException((Object)"last element of an empty set");
        }
        return this.array()[this.size() - 1];
    }

    @Override
    public final int ord(int n) throws NoSuchElementException {
        return this.ord(new RuntimeInt(n));
    }

    @Override
    public final int ord(double d) throws NoSuchElementException {
        return this.ord(new RuntimeReal(d));
    }

    @Override
    public final int ord(Object object) throws NoSuchElementException {
        int n;
        if (this._hasHoles) {
            this._resetIndices();
        }
        if ((n = this.getIndex(object)) == -1) {
            throw new NoSuchElementException((Object)(object + " doesn't belong to this set"));
        }
        return n;
    }

    @Override
    public final int next(int n) throws NoSuchElementException {
        return ((RuntimeInt)this.next(new RuntimeInt(n))).value();
    }

    @Override
    public final double next(double d) throws NoSuchElementException {
        return ((RuntimeReal)this.next(new RuntimeReal(d))).value();
    }

    @Override
    public final Object next(Object object) throws NoSuchElementException {
        int n = this.ord(object) + 1;
        if (n == this.size()) {
            throw new NoSuchElementException((Object)(object + " has no successor in this set"));
        }
        return this.array()[n];
    }

    @Override
    public final int prev(int n) throws NoSuchElementException {
        return ((RuntimeInt)this.prev(new RuntimeInt(n))).value();
    }

    @Override
    public final double prev(double d) throws NoSuchElementException {
        return ((RuntimeReal)this.prev(new RuntimeReal(d))).value();
    }

    @Override
    public final Object prev(Object object) throws NoSuchElementException {
        int n = this.ord(object) - 1;
        if (n == -1) {
            throw new NoSuchElementException((Object)(object + " has no predecessor in this set"));
        }
        return this.array()[n];
    }

    @Override
    public final int nextc(int n) throws NoSuchElementException {
        return ((RuntimeInt)this.nextc(new RuntimeInt(n))).value();
    }

    @Override
    public final double nextc(double d) throws NoSuchElementException {
        return ((RuntimeReal)this.nextc(new RuntimeReal(d))).value();
    }

    @Override
    public final Object nextc(Object object) throws NoSuchElementException {
        return this.array()[(this.ord(object) + 1) % this.size()];
    }

    @Override
    public final int prevc(int n) throws NoSuchElementException {
        return ((RuntimeInt)this.prevc(new RuntimeInt(n))).value();
    }

    @Override
    public final double prevc(double d) throws NoSuchElementException {
        return ((RuntimeReal)this.prevc(new RuntimeReal(d))).value();
    }

    @Override
    public final Object prevc(Object object) throws NoSuchElementException {
        return this.array()[(this.ord(object) + this.size() - 1) % this.size()];
    }

    @Override
    public final RuntimeSet copy() {
        return new ObjectSet(this._map)._setHasHoles(this._hasHoles)._setMaxIndex(this._maxIndex);
    }

    @Override
    public final int getIndex(Object object) {
        int n = this._map.get(object);
        return n == Integer.MIN_VALUE && !this._map.containsKey(object) ? -1 : n;
    }

    @Override
    public final int getIndex(int n) {
        return this.getIndex(new RuntimeInt(n));
    }

    @Override
    public final int getIndex(double d) {
        return this.getIndex(new RuntimeReal(d));
    }

    public final void addObject(Object object) {
        this.add(object);
    }

    @Override
    protected final RuntimeSet _add(Object object) {
        if (!this._map.containsKey(object)) {
            this._map.put(object, this._maxIndex++);
            this._array = null;
        }
        return this;
    }

    @Override
    protected final RuntimeSet _add(int n) {
        return this._add(new RuntimeInt(n));
    }

    @Override
    protected final RuntimeSet _add(double d) {
        return this._add(new RuntimeReal(d));
    }

    @Override
    protected final RuntimeSet _remove(Object object) {
        if (this._hasHoles |= this._map.remove(object) >= 0.0) {
            this._array = null;
        }
        return this;
    }

    @Override
    protected final RuntimeSet _remove(int n) {
        return this._remove(new RuntimeInt(n));
    }

    @Override
    protected final RuntimeSet _remove(double d) {
        return this._remove(new RuntimeReal(d));
    }

    @Override
    public final boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public final boolean contains(int n) {
        return this._map.containsKey(new RuntimeInt(n));
    }

    @Override
    public final boolean contains(double d) {
        return this._map.containsKey(new RuntimeReal(d));
    }

    @Override
    public final boolean contains(RuntimeSet runtimeSet) {
        Iterator iterator = runtimeSet.iterator(false);
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final RuntimeSet _union(RuntimeSet runtimeSet) {
        Iterator iterator = runtimeSet.iterator(true);
        while (iterator.hasNext()) {
            this._add(iterator.next());
        }
        return this;
    }

    @Override
    public final RuntimeSet _intersection(RuntimeSet runtimeSet) {
        Iterator iterator = this.iterator(false);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (runtimeSet.contains(e)) continue;
            this._remove(e);
        }
        return this;
    }

    @Override
    public final RuntimeSet _minus(RuntimeSet runtimeSet) {
        Iterator iterator = runtimeSet.iterator(false);
        while (iterator.hasNext()) {
            this._remove(iterator.next());
        }
        return this;
    }

    @Override
    public final RuntimeSet _exclusion(RuntimeSet runtimeSet) {
        Iterator iterator = runtimeSet.iterator(true);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) {
                this._remove(e);
                continue;
            }
            this._add(e);
        }
        return this;
    }

    @Override
    public final Iterator iterator(boolean bl) {
        return bl ? this.orderedIterator() : this._map.keys();
    }

    @Override
    public final Iterator iterator() {
        return this.iterator(this._isLocked);
    }

    @Override
    public final IntIterator intIterator(boolean bl) {
        return new UnboxedIntIterator(this.iterator(bl));
    }

    @Override
    public final IntIterator intIterator() {
        return new UnboxedIntIterator(this.iterator());
    }

    @Override
    public final DoubleIterator realIterator(boolean bl) {
        return new UnboxedRealIterator(this.iterator(bl));
    }

    @Override
    public final DoubleIterator realIterator() {
        return new UnboxedRealIterator(this.iterator());
    }

    public final Iterator orderedIterator() {
        return new OrderedIterator(this.array());
    }

    @Override
    public final Iterator backwardIterator() {
        return new BackwardIterator(this.array());
    }

    @Override
    public final IntIterator backwardIntIterator() {
        return new UnboxedIntIterator(this.backwardIterator());
    }

    @Override
    public final DoubleIterator backwardRealIterator() {
        return new UnboxedRealIterator(this.backwardIterator());
    }

    @Override
    public final IntIterator indexIterator() {
        return this._map.values();
    }

    public final void slice(int[] nArray) {
        if (this._slice != null && Misc.equal(this._slice, nArray)) {
            return;
        }
        this._slice = nArray;
        if (this._sliceMap == null) {
            this._sliceMap = new HashMap();
        } else {
            this._sliceMap.clear();
        }
        Iterator iterator = this.orderedIterator();
        while (iterator.hasNext()) {
            RuntimeTuple runtimeTuple = (RuntimeTuple)iterator.next();
            Object object = runtimeTuple.getSlicer(nArray);
            ObjectSet objectSet = (ObjectSet)this._sliceMap.get(object);
            if (objectSet == null) {
                objectSet = new ObjectSet();
                this._sliceMap.put(object, objectSet);
            }
            objectSet.add(runtimeTuple);
        }
    }

    @Override
    public final Iterator sliceIterator(int[][] nArray, Object[] objectArray) {
        ObjectSet objectSet = this;
        for (int i = 0; i < objectArray.length; ++i) {
            objectSet.slice(nArray[i]);
            objectSet = objectSet.getSlice(objectArray[i]);
            if (objectSet != null) continue;
            return Misc.EMPTY_ITERATOR;
        }
        return objectSet.orderedIterator();
    }

    public final ObjectSet getSlice(Object object) {
        return (ObjectSet)this._sliceMap.get(object);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexableContainer)) {
            return false;
        }
        IndexableContainer indexableContainer = (IndexableContainer)object;
        if (this.size() != indexableContainer.size()) {
            return false;
        }
        Iterator iterator = this.iterator(false);
        while (iterator.hasNext()) {
            if (indexableContainer.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object object, int[] nArray) {
        if (this == object) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return true;
        }
        if (!(object instanceof Indexable)) {
            return false;
        }
        Indexable indexable = (Indexable)object;
        if (this.size() != indexable.size()) {
            return false;
        }
        Iterator iterator = this._map.iterator();
        while (iterator.hasNext()) {
            ObjectToIntMap.Entry entry = (ObjectToIntMap.Entry)iterator.next();
            int n = indexable.getIndex(entry.key());
            if (n == -1) {
                return false;
            }
            nArray[n] = entry.value();
        }
        return true;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = this.size();
        Iterator iterator = this.iterator(true);
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next()).append(--n == 0 ? "" : ", ");
        }
        return stringBuilder.append("}").toString();
    }

    private static class BackwardIterator
    implements Iterator {
        private Object[] _array;
        private int _index;

        BackwardIterator(Object[] objectArray) {
            this._array = objectArray;
            this._index = this._array.length;
        }

        @Override
        public final boolean hasNext() {
            return this._array == null ? false : this._index > 0;
        }

        public final Object next() {
            return this._array[--this._index];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OrderedIterator
    implements Iterator {
        private Object[] _array;
        private int _index = 0;

        OrderedIterator(Object[] objectArray) {
            this._array = objectArray;
        }

        @Override
        public final boolean hasNext() {
            return this._array == null ? false : this._index < this._array.length;
        }

        public final Object next() {
            return this._array[this._index++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnboxedRealIterator
    implements DoubleIterator {
        private Iterator _iterator;

        UnboxedRealIterator(Iterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public final double next() {
            return ((RuntimeReal)this._iterator.next()).value();
        }
    }

    private static class UnboxedIntIterator
    implements IntIterator {
        private Iterator _iterator;

        UnboxedIntIterator(Iterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public final int next() {
            return ((RuntimeInt)this._iterator.next()).value();
        }
    }
}

