/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntRange;
import hlt.language.design.backend.IntSet;
import hlt.language.design.backend.RealSet;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.RuntimeMap;
import hlt.language.util.DoubleIterator;
import hlt.language.util.IntIterator;
import java.util.Iterator;

public class RealMap
extends RuntimeMap {
    private double[] _array;

    public RealMap(double[] dArray, Indexable indexable) {
        this._array = dArray;
        this._indexable = indexable;
        this._indexable.lock();
    }

    public final double[] array() {
        return this._array;
    }

    @Override
    public final RuntimeMap copy() {
        return new RealMap(Runtime.copy(this._array), this._indexable);
    }

    @Override
    public final Object extractArray() {
        return this._array;
    }

    public final double[] toArray() {
        this.trimToSize();
        return this._array;
    }

    @Override
    public final RuntimeMap setArray(Object object) {
        this._array = (double[])object;
        return this;
    }

    public final double get(double d) {
        return this._array[this._indexable.getIndex(d)];
    }

    public final double get(int n) {
        return this._array[this._indexable.getIndex(n)];
    }

    public final double get(Object object) {
        return this._array[this._indexable.getIndex(object)];
    }

    public final double set(double d, double d2) {
        double d3 = d2;
        this._array[this._indexable.getIndex((double)d)] = d3;
        return d3;
    }

    public final double set(int n, double d) {
        double d2 = d;
        this._array[this._indexable.getIndex((int)n)] = d2;
        return d2;
    }

    public final double set(Object object, double d) {
        double d2 = d;
        this._array[this._indexable.getIndex((Object)object)] = d2;
        return d2;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RealMap)) {
            return false;
        }
        return this._array == ((RealMap)object).array() && this._indexable.equals(((RealMap)object).indexable());
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("#[");
        if (this._indexable instanceof IntRange || this._indexable instanceof IntSet) {
            IntIterator intIterator = this._indexable.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                stringBuilder.append(n).append(":").append(this.get(n));
                if (!intIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        if (this._indexable instanceof RealSet) {
            DoubleIterator doubleIterator = this._indexable.realIterator();
            while (doubleIterator.hasNext()) {
                double d = doubleIterator.next();
                stringBuilder.append(d).append(":").append(this.get(d));
                if (!doubleIterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.append("]#").toString();
        }
        Iterator iterator = this._indexable.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuilder.append(e).append(":").append(this.get(e));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]#").toString();
    }
}

