/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Container;
import hlt.language.design.backend.RuntimeObject;
import hlt.language.design.backend.RuntimeReal;

public class RealRange
implements RuntimeObject,
Container {
    private double _lo;
    private double _hi;

    public RealRange() {
        this._lo = 0.0;
        this._hi = -1.0;
    }

    public RealRange(double d, double d2) {
        if (this._lo > this._hi) {
            this._lo = 0.0;
            this._hi = -1.0;
        } else {
            this._lo = d;
            this._hi = d2;
        }
    }

    @Override
    public final boolean isEmpty() {
        return this._lo > this._hi;
    }

    @Override
    public final boolean contains(double d) {
        return this._lo <= d && d <= this._hi;
    }

    @Override
    public final boolean contains(int n) {
        double d = n;
        return this._lo <= d && d <= this._hi;
    }

    @Override
    public final boolean contains(Object object) {
        double d = ((RuntimeReal)object).value();
        return this._lo <= d && d <= this._hi;
    }

    public final double lb() {
        return this._lo;
    }

    public final double ub() {
        return this._hi;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RealRange)) {
            return false;
        }
        RealRange realRange = (RealRange)object;
        return realRange.lb() == this._lo && realRange.ub() == this._hi;
    }

    public final String toString() {
        return this.isEmpty() ? "<empty real range>" : this._lo + " .. " + this._hi;
    }
}

