/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.NoSuchElementException;
import hlt.language.design.backend.RealRange;
import hlt.language.design.backend.RuntimeReal;
import hlt.language.design.backend.RuntimeSet;
import hlt.language.util.DoubleIterator;
import hlt.language.util.DoubleToIntMap;
import hlt.language.util.IntIterator;
import hlt.language.util.ToIntMap;
import java.util.Iterator;

public class RealSet
extends RuntimeSet {
    private DoubleToIntMap _map = new DoubleToIntMap();
    private double[] _array;
    private RealRange _realRange;
    private double _min = Double.POSITIVE_INFINITY;
    private double _max = Double.NEGATIVE_INFINITY;

    public RealSet() {
    }

    public RealSet(DoubleToIntMap doubleToIntMap) {
        this._map.include(doubleToIntMap);
    }

    @Override
    final ToIntMap map() {
        return this._map;
    }

    public final double[] array() {
        block4: {
            if (this._map.size() <= 0 || this._array != null && !this._hasHoles) break block4;
            this._array = new double[this._map.size()];
            if (this._hasHoles) {
                ToIntMap.Entry[] entryArray = this._resetIndices();
                int n = this._array.length;
                while (n-- > 0) {
                    DoubleToIntMap.Entry entry = (DoubleToIntMap.Entry)entryArray[n];
                    this._array[entry.value()] = entry.key();
                }
            } else {
                Iterator iterator = this._map.iterator();
                while (iterator.hasNext()) {
                    DoubleToIntMap.Entry entry = (DoubleToIntMap.Entry)iterator.next();
                    this._array[entry.value()] = entry.key();
                }
            }
        }
        return this._array;
    }

    @Override
    public final int firstInt() throws NoSuchElementException {
        return (int)this.firstReal();
    }

    @Override
    public final double firstReal() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException((Object)"first element of an empty set");
        }
        return this.array()[0];
    }

    @Override
    public final Object firstObject() throws NoSuchElementException {
        return new RuntimeReal(this.firstReal());
    }

    @Override
    public final int lastInt() throws NoSuchElementException {
        return (int)this.lastReal();
    }

    @Override
    public final double lastReal() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException((Object)"last element of an empty set");
        }
        return this.array()[this.size() - 1];
    }

    @Override
    public final Object lastObject() throws NoSuchElementException {
        return new RuntimeReal(this.lastReal());
    }

    @Override
    public final int ord(int n) throws NoSuchElementException {
        return this.ord((double)n);
    }

    @Override
    public final int ord(double d) throws NoSuchElementException {
        int n;
        if (this._hasHoles) {
            this._resetIndices();
        }
        if ((n = this.getIndex(d)) == -1) {
            throw new NoSuchElementException((Object)(d + " doesn't belong to this set"));
        }
        return n;
    }

    @Override
    public final int ord(Object object) throws NoSuchElementException {
        return this.ord(((RuntimeReal)object).value());
    }

    @Override
    public final int next(int n) throws NoSuchElementException {
        return (int)this.next((double)n);
    }

    @Override
    public final double next(double d) throws NoSuchElementException {
        int n = this.ord(d) + 1;
        if (n == this.size()) {
            throw new NoSuchElementException((Object)(d + " has no successor in this set"));
        }
        return this.array()[n];
    }

    @Override
    public final Object next(Object object) throws NoSuchElementException {
        return new RuntimeReal(this.next(((RuntimeReal)object).value()));
    }

    @Override
    public final int prev(int n) throws NoSuchElementException {
        return (int)this.prev((double)n);
    }

    @Override
    public final double prev(double d) throws NoSuchElementException {
        int n = this.ord(d) - 1;
        if (n == -1) {
            throw new NoSuchElementException((Object)(d + " has no predecessor in this set"));
        }
        return this.array()[n];
    }

    @Override
    public final Object prev(Object object) throws NoSuchElementException {
        return new RuntimeReal(this.prev(((RuntimeReal)object).value()));
    }

    @Override
    public final int nextc(int n) throws NoSuchElementException {
        return (int)this.nextc((double)n);
    }

    @Override
    public final double nextc(double d) throws NoSuchElementException {
        return this.array()[(this.ord(d) + 1) % this.size()];
    }

    @Override
    public final Object nextc(Object object) throws NoSuchElementException {
        return new RuntimeReal(this.next(((RuntimeReal)object).value()));
    }

    @Override
    public final int prevc(int n) throws NoSuchElementException {
        return (int)this.prevc((double)n);
    }

    @Override
    public final double prevc(double d) throws NoSuchElementException {
        return this.array()[(this.ord(d) + this.size() - 1) % this.size()];
    }

    @Override
    public final Object prevc(Object object) throws NoSuchElementException {
        return new RuntimeReal(this.prevc(((RuntimeReal)object).value()));
    }

    @Override
    public final RuntimeSet copy() {
        return new RealSet(this._map)._setHasHoles(this._hasHoles)._setMaxIndex(this._maxIndex);
    }

    @Override
    public final int getIndex(double d) {
        int n = this._map.get(d);
        return n == Integer.MIN_VALUE && !this._map.containsKey(d) ? -1 : n;
    }

    @Override
    public final int getIndex(int n) {
        return this.getIndex((double)n);
    }

    @Override
    public final int getIndex(Object object) {
        return this.getIndex(((RuntimeReal)object).value());
    }

    public final double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException((Object)"attempt to take the minimum element of an empty set");
        }
        return this._min;
    }

    public final double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException((Object)"attempt to take the maximum element of an empty set");
        }
        return this._max;
    }

    @Override
    protected final RuntimeSet _add(double d) {
        if (!this._map.containsKey(d)) {
            double d2;
            this._map.put(d, this._maxIndex++);
            double d3 = this.size() == 1 ? d : Math.min(this._min, d);
            double d4 = d2 = this.size() == 1 ? d : Math.max(this._max, d);
            if (d3 != this._min || d2 != this._max) {
                this._realRange = null;
            }
            this._array = null;
            this._min = d3;
            this._max = d2;
        }
        return this;
    }

    @Override
    protected final RuntimeSet _add(int n) {
        return this._add((double)n);
    }

    @Override
    protected final RuntimeSet _add(Object object) {
        return this._add(((RuntimeReal)object).value());
    }

    @Override
    protected final RuntimeSet _remove(double d) {
        if (this._hasHoles |= this._map.remove(d) >= 0) {
            if (d == this._min) {
                this._recomputeMin();
            }
            if (d == this._max) {
                this._recomputeMax();
            }
            this._array = null;
        }
        return this;
    }

    @Override
    protected final RuntimeSet _remove(int n) {
        return this._remove((double)n);
    }

    @Override
    protected final RuntimeSet _remove(Object object) {
        return this._remove(((RuntimeReal)object).value());
    }

    @Override
    public final boolean contains(double d) {
        return this._map.containsKey(d);
    }

    @Override
    public final boolean contains(int n) {
        return this._map.containsKey(n);
    }

    @Override
    public final boolean contains(Object object) {
        return this._map.containsKey(((RuntimeReal)object).value());
    }

    @Override
    public final boolean contains(RuntimeSet runtimeSet) {
        DoubleIterator doubleIterator = runtimeSet.realIterator(false);
        while (doubleIterator.hasNext()) {
            if (this.contains(doubleIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final RuntimeSet _union(RuntimeSet runtimeSet) {
        DoubleIterator doubleIterator = runtimeSet.realIterator(true);
        while (doubleIterator.hasNext()) {
            this._add(doubleIterator.next());
        }
        return this;
    }

    @Override
    public final RuntimeSet _intersection(RuntimeSet runtimeSet) {
        DoubleIterator doubleIterator = this.realIterator(false);
        while (doubleIterator.hasNext()) {
            double d = doubleIterator.next();
            if (runtimeSet.contains(d)) continue;
            this._remove(d);
        }
        return this;
    }

    @Override
    public final RuntimeSet _minus(RuntimeSet runtimeSet) {
        DoubleIterator doubleIterator = runtimeSet.realIterator(false);
        while (doubleIterator.hasNext()) {
            this._remove(doubleIterator.next());
        }
        return this;
    }

    @Override
    public final RuntimeSet _exclusion(RuntimeSet runtimeSet) {
        DoubleIterator doubleIterator = runtimeSet.realIterator(true);
        while (doubleIterator.hasNext()) {
            double d = doubleIterator.next();
            if (this.contains(d)) {
                this._remove(d);
                continue;
            }
            this._add(d);
        }
        return this;
    }

    public final void _recomputeMin() {
        this._min = Double.POSITIVE_INFINITY;
        DoubleIterator doubleIterator = this.realIterator(false);
        while (doubleIterator.hasNext()) {
            this._min = Math.min(this._min, doubleIterator.next());
        }
        this._realRange = null;
    }

    public final void _recomputeMax() {
        this._max = Double.NEGATIVE_INFINITY;
        DoubleIterator doubleIterator = this.realIterator(false);
        while (doubleIterator.hasNext()) {
            this._max = Math.max(this._max, doubleIterator.next());
        }
        this._realRange = null;
    }

    public final RealRange toRealRange() {
        if (this._realRange != null) {
            return this._realRange;
        }
        this._realRange = this.isEmpty() ? new RealRange() : new RealRange(this._min, this._max);
        return this._realRange;
    }

    @Override
    public final DoubleIterator realIterator(boolean bl) {
        return bl ? this.orderedIterator() : this._map.keys();
    }

    @Override
    public final DoubleIterator realIterator() {
        return this.realIterator(this._isLocked);
    }

    @Override
    public final Iterator iterator(boolean bl) {
        return new BoxedRealIterator(this.realIterator(bl));
    }

    @Override
    public final Iterator iterator() {
        return new BoxedRealIterator(this.realIterator());
    }

    @Override
    public final IntIterator intIterator(boolean bl) {
        return new CastIterator(this.realIterator(bl));
    }

    @Override
    public final IntIterator intIterator() {
        return new CastIterator(this.realIterator());
    }

    public final DoubleIterator orderedIterator() {
        return new OrderedIterator(this.array());
    }

    @Override
    public final DoubleIterator backwardRealIterator() {
        return new BackwardIterator(this.array());
    }

    @Override
    public final IntIterator backwardIntIterator() {
        return new CastIterator(this.backwardRealIterator());
    }

    @Override
    public final Iterator backwardIterator() {
        return new BoxedRealIterator(this.backwardRealIterator());
    }

    @Override
    public final IntIterator indexIterator() {
        return this._map.values();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuntimeSet)) {
            return false;
        }
        RuntimeSet runtimeSet = (RuntimeSet)object;
        if (this.size() != runtimeSet.size()) {
            return false;
        }
        DoubleIterator doubleIterator = this.realIterator(false);
        while (doubleIterator.hasNext()) {
            if (runtimeSet.contains(doubleIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object object, int[] nArray) {
        if (this == object) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return true;
        }
        if (!(object instanceof RuntimeSet)) {
            return false;
        }
        RuntimeSet runtimeSet = (RuntimeSet)object;
        if (this.size() != runtimeSet.size()) {
            return false;
        }
        Iterator iterator = this._map.iterator();
        while (iterator.hasNext()) {
            DoubleToIntMap.Entry entry = (DoubleToIntMap.Entry)iterator.next();
            int n = runtimeSet.getIndex(entry.key());
            if (n == -1) {
                return false;
            }
            nArray[n] = entry.value();
        }
        return true;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = this.size();
        DoubleIterator doubleIterator = this.realIterator(true);
        while (doubleIterator.hasNext()) {
            stringBuilder.append(doubleIterator.next()).append(--n == 0 ? "" : ", ");
        }
        return stringBuilder.append("}").toString();
    }

    private static class BackwardIterator
    implements DoubleIterator {
        private double[] _array;
        private int _index;

        BackwardIterator(double[] dArray) {
            this._array = dArray;
            this._index = this._array.length;
        }

        @Override
        public final boolean hasNext() {
            return this._array == null ? false : this._index > 0;
        }

        @Override
        public final double next() {
            return this._array[--this._index];
        }
    }

    private static class OrderedIterator
    implements DoubleIterator {
        private double[] _array;
        private int _index = 0;

        OrderedIterator(double[] dArray) {
            this._array = dArray;
        }

        @Override
        public final boolean hasNext() {
            return this._array == null ? false : this._index < this._array.length;
        }

        @Override
        public final double next() {
            return this._array[this._index++];
        }
    }

    private static class CastIterator
    implements IntIterator {
        private DoubleIterator _iterator;

        CastIterator(DoubleIterator doubleIterator) {
            this._iterator = doubleIterator;
        }

        @Override
        public final boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public final int next() {
            return (int)this._iterator.next();
        }
    }

    private static class BoxedRealIterator
    implements Iterator {
        private DoubleIterator _iterator;

        BoxedRealIterator(DoubleIterator doubleIterator) {
            this._iterator = doubleIterator;
        }

        @Override
        public final boolean hasNext() {
            return this._iterator.hasNext();
        }

        public final Object next() {
            return new RuntimeReal(this._iterator.next());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

