/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.Block;
import hlt.language.design.backend.DefaultDisplayManager;
import hlt.language.design.backend.DisplayDeviceManager;
import hlt.language.design.backend.DisplayFormManager;
import hlt.language.design.backend.DisplayManager;
import hlt.language.design.backend.IntMap;
import hlt.language.design.backend.NullValueException;
import hlt.language.design.backend.ObjectMap;
import hlt.language.design.backend.RealMap;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeMap;
import hlt.language.design.backend.RuntimeReal;
import hlt.language.design.backend.UnsafeCodeException;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.Type;
import hlt.language.tools.Debug;
import hlt.language.util.DoubleStack;
import hlt.language.util.IntStack;
import hlt.language.util.Stack;

public class Runtime {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int VOID = -1;
    public static final RuntimeInt BOXED_FALSE = Runtime.newInt(0);
    public static final RuntimeInt BOXED_TRUE = Runtime.newInt(1);
    public static final RuntimeInt BOXED_VOID = Runtime.newInt(-1);
    protected Instruction[] _code;
    protected int _ip;
    protected Stack _saveStack = new Stack();
    protected Stack _callStack = new Stack();
    protected IntStack _intStack = new IntStack();
    protected DoubleStack _realStack = new DoubleStack();
    protected Stack _objectStack = new Stack();
    protected IntStack _intEnv = new IntStack();
    protected DoubleStack _realEnv = new DoubleStack();
    protected Stack _objectEnv = new Stack();
    protected State _currentExitableState = null;
    protected byte _resultSort;
    private boolean _terminated = false;
    private static boolean _tracing = false;
    private DisplayManager _displayManager = new DefaultDisplayManager();

    public final DisplayManager displayManager() {
        return this._displayManager;
    }

    public final DisplayManager getDisplayManager() {
        return this._displayManager;
    }

    public final Runtime setDisplayManager(DisplayManager displayManager) {
        this._displayManager = displayManager;
        return this;
    }

    public final DisplayDeviceManager displayDeviceManager() {
        return this._displayManager.displayDeviceManager();
    }

    public final DisplayDeviceManager getDisplayDeviceManager() {
        return this._displayManager.displayDeviceManager();
    }

    public final Runtime setDisplayDeviceManager(DisplayDeviceManager displayDeviceManager) {
        this._displayManager.setDisplayDeviceManager(displayDeviceManager);
        return this;
    }

    public final DisplayFormManager displayFormManager() {
        return this._displayManager.displayFormManager();
    }

    public final DisplayFormManager getDisplayFormManager() {
        return this._displayManager.displayFormManager();
    }

    public final Runtime setDisplayFormManager(DisplayFormManager displayFormManager) {
        this._displayManager.setDisplayFormManager(displayFormManager);
        return this;
    }

    public final void setCode(Instruction[] instructionArray) {
        this._code = instructionArray;
    }

    public final int ip() {
        return this._ip;
    }

    public final void setIP(int n) {
        this._ip = n;
    }

    public final void resetIP() {
        this._ip = 0;
        this._terminated = false;
    }

    public final void incIP() {
        ++this._ip;
    }

    public final void pushInt(int n) {
        this._intStack.push(n);
        this._resultSort = 1;
    }

    public final void pushReal(double d) {
        this._realStack.push(d);
        this._resultSort = (byte)2;
    }

    public final void pushObject(Object object) {
        this._objectStack.push(object);
        this._resultSort = (byte)3;
    }

    public final void pushBoolean(boolean bl) {
        this._intStack.push(bl ? 1 : 0);
        this._resultSort = 1;
    }

    public final char popChar() {
        return (char)this.popInt();
    }

    public final void pushChar(char c) {
        this.pushInt(c);
    }

    public final byte resultSort() {
        return this._resultSort;
    }

    public final void setIntSort() {
        this._resultSort = 1;
    }

    public final void setRealSort() {
        this._resultSort = (byte)2;
    }

    public final void setObjectSort() {
        this._resultSort = (byte)3;
    }

    public final int intResult() {
        return this._intStack.peek();
    }

    public final double realResult() {
        return this._realStack.peek();
    }

    public final Object objectResult() {
        return this._objectStack.peek();
    }

    public final boolean booleanResult() {
        return this._intStack.peek() == 1;
    }

    public final int popInt() {
        return this._intStack.pop();
    }

    public final double popReal() {
        return this._realStack.pop();
    }

    public final Object popObject() {
        return this._objectStack.pop();
    }

    public final Object popObject(Object object) throws NullValueException {
        Object object2 = this._objectStack.pop();
        if (object2 == null) {
            throw new NullValueException(object);
        }
        return object2;
    }

    public final boolean popBoolean() {
        return this._intStack.pop() == 1;
    }

    public int[] popIntArray() {
        Object object = this._objectStack.pop();
        if (object instanceof IntMap) {
            return ((IntMap)object).array();
        }
        return (int[])object;
    }

    public int[] popIntArray(Object object) throws NullValueException {
        Object object2 = this.popObject(object);
        if (object2 instanceof IntMap) {
            return ((IntMap)object2).array();
        }
        return (int[])object2;
    }

    public double[] popRealArray() {
        Object object = this._objectStack.pop();
        if (object instanceof RealMap) {
            return ((RealMap)object).array();
        }
        return (double[])object;
    }

    public double[] popRealArray(Object object) throws NullValueException {
        Object object2 = this.popObject(object);
        if (object2 instanceof RealMap) {
            return ((RealMap)object2).array();
        }
        return (double[])object2;
    }

    public Object[] popObjectArray() {
        Object object = this._objectStack.pop();
        if (object instanceof ObjectMap) {
            return ((ObjectMap)object).array();
        }
        return (Object[])object;
    }

    public Object[] popObjectArray(Object object) throws NullValueException {
        Object object2 = this.popObject(object);
        if (object2 instanceof ObjectMap) {
            return ((ObjectMap)object2).array();
        }
        return (Object[])object2;
    }

    public static final RuntimeInt newInt(int n) {
        switch (n) {
            case 0: {
                return RuntimeInt.ZERO;
            }
            case 1: {
                return RuntimeInt.ONE;
            }
        }
        return new RuntimeInt(n);
    }

    public static final RuntimeReal newReal(double d) {
        if (d == 0.0) {
            return RuntimeReal.ZERO;
        }
        return new RuntimeReal(d);
    }

    public final void pushIntEnv(int n) {
        this._intEnv.push(n);
    }

    public final void pushRealEnv(double d) {
        this._realEnv.push(d);
    }

    public final void pushObjectEnv(Object object) {
        this._objectEnv.push(object);
    }

    public final void pushIntEnvArray(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this._intEnv.push(nArray[i]);
        }
    }

    public final void pushRealEnvArray(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this._realEnv.push(dArray[i]);
        }
    }

    public final void pushObjectEnvArray(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this._objectEnv.push(objectArray[i]);
        }
    }

    public final int[] copyIntEnv(int n) {
        int[] nArray = new int[n];
        int n2 = this._intEnv.size() - n;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this._intEnv.get(n2 + i);
        }
        return nArray;
    }

    public final double[] copyRealEnv(int n) {
        double[] dArray = new double[n];
        int n2 = this._realEnv.size() - n;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this._realEnv.get(n2 + i);
        }
        return dArray;
    }

    public final Object[] copyObjectEnv(int n) {
        Object[] objectArray = new Object[n];
        int n2 = this._objectEnv.size() - n;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objectEnv.get(n2 + i);
        }
        return objectArray;
    }

    public final int getIntEnv(int n) {
        return this._intEnv.peek(n);
    }

    public final double getRealEnv(int n) {
        return this._realEnv.peek(n);
    }

    public final Object getObjectEnv(int n) {
        return this._objectEnv.peek(n);
    }

    public static final int[] copy(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final double[] copy(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static final Object[] copy(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = Runtime._copyIfArray(objectArray[i]);
        }
        return objectArray2;
    }

    private static final Object _copyIfArray(Object object) {
        if (object instanceof int[]) {
            return Runtime.copy((int[])object);
        }
        if (object instanceof double[]) {
            return Runtime.copy((double[])object);
        }
        if (object instanceof Object[]) {
            return Runtime.copy((Object[])object);
        }
        if (object instanceof RuntimeMap) {
            return ((RuntimeMap)object).copy();
        }
        return object;
    }

    public final void setIntEnv(int n) {
        this._intEnv.replace(n, this._intStack.peek());
    }

    public final void setRealEnv(int n) {
        this._realEnv.replace(n, this._realStack.peek());
    }

    public final void setObjectEnv(int n) {
        this._objectEnv.replace(n, this._objectStack.peek());
    }

    public final void setIntValue(int n) {
        this._intEnv.setLast(n);
    }

    public final void setRealValue(double d) {
        this._realEnv.setLast(d);
    }

    public final void setObjectValue(Object object) {
        this._objectEnv.setLast(object);
    }

    public final void pushExitableState(State state) {
        state.setEnclosingExitableState(this._currentExitableState);
        this._currentExitableState = state.setIsExitable(true);
    }

    public final State popExitableState() {
        State state = this._currentExitableState;
        this._currentExitableState = this._currentExitableState.getEnclosingExitableState();
        return state;
    }

    public final void enterExitableScope() {
        this.pushExitableState(this.saveState());
    }

    public final void enterExitableScope(int n, int n2, int n3) {
        this.pushExitableState(this.saveState(n, n2, n3));
    }

    public final void leaveExitableScope() {
        this.restoreState(this.popExitableState());
    }

    public final State saveState() {
        State state = new State(this._code, this._ip + 1, this._intStack.size(), this._realStack.size(), this._objectStack.size(), this._intEnv.size(), this._realEnv.size(), this._objectEnv.size()).setCurrentExitableState(this._currentExitableState);
        this._saveStack.push(state);
        return state;
    }

    public final State saveState(int n, int n2, int n3) {
        State state = new State(this._code, this._ip + 1, this._intStack.size() - n, this._realStack.size() - n2, this._objectStack.size() - n3, this._intEnv.size(), this._realEnv.size(), this._objectEnv.size()).setCurrentExitableState(this._currentExitableState);
        this._saveStack.push(state);
        return state;
    }

    public final void restoreState() {
        this.restoreState((State)this._saveStack.peek());
        this._terminated = false;
    }

    public final void restoreState(State state) {
        while (this._saveStack.peek() != state) {
            this._saveStack.pop();
        }
        this._saveStack.pop();
        this._code = state.code();
        this._ip = state.ip();
        this._currentExitableState = state.getCurrentExitableState();
        this._intStack.setSize(state.intStackPoint());
        this._realStack.setSize(state.realStackPoint());
        this._objectStack.setSize(state.objectStackPoint());
        this._intEnv.setSize(state.intEnvPoint());
        this._realEnv.setSize(state.realEnvPoint());
        this._objectEnv.setSize(state.objectEnvPoint());
    }

    public final void pushCall(DefinedEntry definedEntry) throws UnsafeCodeException {
        if (definedEntry.isUnsafe()) {
            throw new UnsafeCodeException(definedEntry);
        }
        this._callStack.push(new CallState(definedEntry, this._code, this._ip + 1));
        this._code = definedEntry.code();
        this._ip = 0;
    }

    public final void popCall() {
        if (this._callStack.isEmpty()) {
            this._terminated = true;
        } else {
            CallState callState = (CallState)this._callStack.pop();
            this._code = callState.code();
            this._ip = callState.ip();
            DefinedEntry definedEntry = callState.entry();
            if (definedEntry.isSetOnEvaluation()) {
                this.setValue(definedEntry);
            }
        }
    }

    public final void setValue(DefinedEntry definedEntry) {
        switch (definedEntry.type().boxSort()) {
            case 1: {
                definedEntry.setValue(this._intStack.peek());
                break;
            }
            case 2: {
                definedEntry.setValue(this._realStack.peek());
                break;
            }
            default: {
                definedEntry.setValue(this._objectStack.peek());
            }
        }
    }

    public final Runtime reset() {
        this._clearAllStacks();
        this._ip = 0;
        this._terminated = false;
        return this;
    }

    public final void initialize(Instruction[] instructionArray) {
        this.reset();
        this._code = instructionArray;
    }

    private final void _clearAllStacks() {
        this._saveStack.clear();
        this._callStack.clear();
        this._intStack.clear();
        this._realStack.clear();
        this._objectStack.clear();
        this._intEnv.clear();
        this._realEnv.clear();
        this._objectEnv.clear();
    }

    public final void run(Instruction[] instructionArray) throws Exception {
        this.initialize(instructionArray);
        this.run();
    }

    public final void run() throws Exception {
        while (!this._terminated) {
            if (_tracing) {
                this._showState();
            }
            this._currentInstruction().execute(this);
        }
    }

    public final void runBody(Block block) throws Exception {
        this._code = block.code();
        this._ip = block.address();
        Instruction instruction = null;
        while (true) {
            if (_tracing) {
                this._showState();
            }
            if ((instruction = this._currentInstruction()).isReturn()) {
                return;
            }
            instruction.execute(this);
        }
    }

    private final Instruction _currentInstruction() {
        return this._code[this._ip];
    }

    public final void stop() {
        this._terminated = true;
    }

    public static final void toggleTrace() {
        _tracing = !_tracing;
    }

    public static final boolean isTracing() {
        return _tracing;
    }

    protected boolean mustStop() {
        return true;
    }

    private final void _showStacks(IntStack intStack, DoubleStack doubleStack, Stack stack) {
        int n;
        System.out.println("\n\tINT:\t\tREAL:\t\tOBJECT:\n");
        int n2 = n = Math.max(intStack.size(), Math.max(doubleStack.size(), stack.size()));
        while (n2-- > 0) {
            System.out.println();
            int n3 = n2 - n + intStack.size();
            if (n3 >= 0) {
                System.out.print("\t" + n3 + ":\t" + intStack.get(n3));
            } else {
                System.out.print("\t\t");
            }
            n3 = n2 - n + doubleStack.size();
            if (n3 >= 0) {
                System.out.print("\t" + n3 + ":\t" + doubleStack.get(n3));
            } else {
                System.out.print("\t\t");
            }
            if ((n3 = n2 - n + stack.size()) < 0) continue;
            System.out.print("\t" + n3 + ":\t" + stack.get(n3));
        }
    }

    public final void showState() {
        this._showState();
    }

    private final void _showState() {
        System.out.println("===============================================");
        System.out.println("\nRESULT STACKS:\n");
        this._showStacks(this._intStack, this._realStack, this._objectStack);
        System.out.println("\n");
        System.out.println("\nENVIRONMENTS:\n");
        this._showStacks(this._intEnv, this._realEnv, this._objectEnv);
        System.out.println("\n");
        System.out.println("\nSAVE STACK:\n");
        int n = this._saveStack.size();
        while (n-- > 0) {
            State state;
            System.out.println("\t" + n + ": " + state + ((state = (State)this._saveStack.get(n)) == this._currentExitableState ? "\t<== CURRENT" : ""));
        }
        System.out.println("\n");
        System.out.println("\nCALL STACK:\n");
        n = this._callStack.size();
        while (n-- > 0) {
            System.out.println("\t" + n + ": " + this._callStack.get(n));
        }
        System.out.println("\n");
        CodeEntry.showCode(this._code, this._ip);
        if (this.mustStop()) {
            Debug.step();
        }
    }

    protected static class State
    extends AbstractState {
        private int _intStackPoint;
        private int _realStackPoint;
        private int _objectStackPoint;
        private int _intEnvPoint;
        private int _realEnvPoint;
        private int _objectEnvPoint;
        private boolean _isExitable = false;
        private State _currentExitableState;
        private State _enclosingExitableState;

        public final boolean isExitable() {
            return this._isExitable;
        }

        public final State setIsExitable(boolean bl) {
            this._isExitable = bl;
            return this;
        }

        public final State getCurrentExitableState() {
            return this._currentExitableState;
        }

        public final State getEnclosingExitableState() {
            return this._enclosingExitableState;
        }

        public final State setCurrentExitableState(State state) {
            this._currentExitableState = state;
            return this;
        }

        public final State setEnclosingExitableState(State state) {
            this._enclosingExitableState = state;
            return this;
        }

        State(Instruction[] instructionArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            super(instructionArray, n);
            this._intStackPoint = n2;
            this._realStackPoint = n3;
            this._objectStackPoint = n4;
            this._intEnvPoint = n5;
            this._realEnvPoint = n6;
            this._objectEnvPoint = n7;
        }

        final int intStackPoint() {
            return this._intStackPoint;
        }

        final int realStackPoint() {
            return this._realStackPoint;
        }

        final int objectStackPoint() {
            return this._objectStackPoint;
        }

        final int intEnvPoint() {
            return this._intEnvPoint;
        }

        final int realEnvPoint() {
            return this._realEnvPoint;
        }

        final int objectEnvPoint() {
            return this._objectEnvPoint;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof State)) {
                return false;
            }
            return this._code == ((State)object)._code && this._ip == ((State)object)._ip && this._intStackPoint == ((State)object)._intStackPoint && this._realStackPoint == ((State)object)._realStackPoint && this._objectStackPoint == ((State)object)._objectStackPoint && this._intEnvPoint == ((State)object)._intEnvPoint && this._realEnvPoint == ((State)object)._realEnvPoint && this._objectEnvPoint == ((State)object)._objectEnvPoint && this._isExitable == ((State)object)._isExitable && this._currentExitableState == ((State)object)._currentExitableState && this._enclosingExitableState == ((State)object)._enclosingExitableState;
        }

        public final int hashCode() {
            return this._code.hashCode() + this._ip + this._intStackPoint + this._realStackPoint + this._objectStackPoint + this._intEnvPoint + this._realEnvPoint + this._objectEnvPoint;
        }

        @Override
        public final String toString() {
            return super.toString() + "\tSP = <" + this._intStackPoint + "," + this._realStackPoint + "," + this._objectStackPoint + ">\tEP = <" + this._intEnvPoint + "," + this._realEnvPoint + "," + this._objectEnvPoint + ">\t" + (this._isExitable ? "" : "NON-") + "EXITABLE";
        }
    }

    protected static class CallState
    extends AbstractState {
        private DefinedEntry _entry;

        CallState(DefinedEntry definedEntry, Instruction[] instructionArray, int n) {
            super(instructionArray, n);
            this._entry = definedEntry;
        }

        final DefinedEntry entry() {
            return this._entry;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CallState)) {
                return false;
            }
            return this._entry == ((CallState)object)._entry && this._code == ((CallState)object)._code && this._ip == ((CallState)object)._ip;
        }

        public final int hashCode() {
            return this._entry.hashCode() + this._code.hashCode() + this._ip;
        }

        @Override
        public String toString() {
            Type.resetNames();
            return super.toString() + "\tENTRY = " + this._entry;
        }
    }

    private static abstract class AbstractState {
        protected Instruction[] _code;
        protected int _ip;

        protected AbstractState(Instruction[] instructionArray, int n) {
            this._code = instructionArray;
            this._ip = n;
        }

        final Instruction[] code() {
            return this._code;
        }

        final int ip() {
            return this._ip;
        }

        public String toString() {
            return CodeEntry.getId(this._code) + "\tIP = " + this._ip;
        }
    }
}

