/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.IndexableContainer;
import hlt.language.design.backend.LockViolationException;
import hlt.language.design.backend.NoSuchElementException;
import hlt.language.design.backend.RuntimeObject;
import hlt.language.tools.Misc;
import hlt.language.util.Comparable;
import hlt.language.util.ToIntMap;
import java.util.Iterator;

public abstract class RuntimeSet
implements RuntimeObject,
IndexableContainer {
    protected boolean _hasHoles = false;
    protected int _maxIndex = 0;
    protected boolean _isLocked = false;

    abstract ToIntMap map();

    protected final boolean _hasHoles() {
        return this._hasHoles;
    }

    protected final RuntimeSet _setHasHoles(boolean bl) {
        this._hasHoles = bl;
        return this;
    }

    protected final RuntimeSet _setMaxIndex(int n) {
        this._maxIndex = n;
        return this;
    }

    @Override
    public final void lock() {
        this._isLocked = true;
    }

    @Override
    public final void unlock() {
        this._isLocked = false;
    }

    @Override
    public final boolean isLocked() {
        return this._isLocked;
    }

    @Override
    public final int size() {
        return this.map().size();
    }

    @Override
    public final boolean isEmpty() {
        return this.map().isEmpty();
    }

    public final int hashCode() {
        return this.size();
    }

    protected final ToIntMap.Entry[] _resetIndices() {
        Comparable[] comparableArray = new ToIntMap.Entry[this.size()];
        int n = 0;
        Iterator iterator = this.map().iterator();
        while (iterator.hasNext()) {
            comparableArray[n++] = (ToIntMap.Entry)iterator.next();
        }
        Misc.sort(comparableArray);
        while (n-- > 0) {
            ((ToIntMap.Entry)comparableArray[n]).setValue(n);
        }
        this._hasHoles = false;
        this._maxIndex = this.size();
        return comparableArray;
    }

    @Override
    public abstract boolean equals(Object var1, int[] var2);

    public abstract int firstInt() throws NoSuchElementException;

    public abstract double firstReal() throws NoSuchElementException;

    public abstract Object firstObject() throws NoSuchElementException;

    public abstract int lastInt() throws NoSuchElementException;

    public abstract double lastReal() throws NoSuchElementException;

    public abstract Object lastObject() throws NoSuchElementException;

    public abstract int ord(int var1) throws NoSuchElementException;

    public abstract int ord(double var1) throws NoSuchElementException;

    public abstract int ord(Object var1) throws NoSuchElementException;

    public abstract int next(int var1) throws NoSuchElementException;

    public abstract double next(double var1) throws NoSuchElementException;

    public abstract Object next(Object var1) throws NoSuchElementException;

    public abstract int prev(int var1) throws NoSuchElementException;

    public abstract double prev(double var1) throws NoSuchElementException;

    public abstract Object prev(Object var1) throws NoSuchElementException;

    public abstract int nextc(int var1) throws NoSuchElementException;

    public abstract double nextc(double var1) throws NoSuchElementException;

    public abstract Object nextc(Object var1) throws NoSuchElementException;

    public abstract int prevc(int var1) throws NoSuchElementException;

    public abstract double prevc(double var1) throws NoSuchElementException;

    public abstract Object prevc(Object var1) throws NoSuchElementException;

    protected abstract RuntimeSet _union(RuntimeSet var1);

    protected abstract RuntimeSet _intersection(RuntimeSet var1);

    protected abstract RuntimeSet _minus(RuntimeSet var1);

    protected abstract RuntimeSet _exclusion(RuntimeSet var1);

    protected abstract RuntimeSet _add(int var1);

    protected abstract RuntimeSet _add(double var1);

    protected abstract RuntimeSet _add(Object var1);

    protected abstract RuntimeSet _remove(int var1);

    protected abstract RuntimeSet _remove(double var1);

    protected abstract RuntimeSet _remove(Object var1);

    public final RuntimeSet union(RuntimeSet runtimeSet) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._union(runtimeSet);
    }

    public final RuntimeSet intersection(RuntimeSet runtimeSet) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._intersection(runtimeSet);
    }

    public final RuntimeSet minus(RuntimeSet runtimeSet) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._minus(runtimeSet);
    }

    public final RuntimeSet exclusion(RuntimeSet runtimeSet) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._exclusion(runtimeSet);
    }

    public static final RuntimeSet union(RuntimeSet runtimeSet, RuntimeSet runtimeSet2) {
        return runtimeSet.copy()._union(runtimeSet2);
    }

    public static final RuntimeSet intersection(RuntimeSet runtimeSet, RuntimeSet runtimeSet2) {
        return runtimeSet.copy()._intersection(runtimeSet2);
    }

    public static final RuntimeSet minus(RuntimeSet runtimeSet, RuntimeSet runtimeSet2) {
        return runtimeSet.copy()._minus(runtimeSet2);
    }

    public static final RuntimeSet exclusion(RuntimeSet runtimeSet, RuntimeSet runtimeSet2) {
        return runtimeSet.copy()._exclusion(runtimeSet2);
    }

    public abstract RuntimeSet copy();

    public abstract boolean contains(RuntimeSet var1);

    public final RuntimeSet add(int n) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._add(n);
    }

    public final RuntimeSet add(double d) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._add(d);
    }

    public final RuntimeSet add(Object object) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._add(object);
    }

    public final RuntimeSet remove(int n) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._remove(n);
    }

    public final RuntimeSet remove(double d) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._remove(d);
    }

    public final RuntimeSet remove(Object object) throws LockViolationException {
        if (this._isLocked) {
            throw new LockViolationException();
        }
        return this._remove(object);
    }
}

