/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.backend;

import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeObject;
import hlt.language.design.backend.RuntimeReal;

public class RuntimeTuple
implements RuntimeObject {
    private int[] _intComponents;
    private double[] _realComponents;
    private Object[] _objectComponents;
    public static final RuntimeTuple EMPTY = new RuntimeTuple(null, null, null);

    public RuntimeTuple(int[] nArray, double[] dArray, Object[] objectArray) {
        this._intComponents = nArray;
        this._realComponents = dArray;
        this._objectComponents = objectArray;
    }

    public int[] intComponents() {
        return this._intComponents;
    }

    public double[] realComponents() {
        return this._realComponents;
    }

    public final double[] floatComponents() {
        return this.realComponents();
    }

    public Object[] objectComponents() {
        return this._objectComponents;
    }

    public int intDimension() {
        return this._intComponents == null ? 0 : this._intComponents.length;
    }

    public int realDimension() {
        return this._realComponents == null ? 0 : this._realComponents.length;
    }

    public final int floatDimension() {
        return this.realDimension();
    }

    public int objectDimension() {
        return this._objectComponents == null ? 0 : this._objectComponents.length;
    }

    public final int getIntComponent(int n) {
        return this._intComponents[n - 1];
    }

    public final int setIntComponent(int n, int n2) {
        int n3 = n2;
        this._intComponents[n - 1] = n3;
        return n3;
    }

    public final double getRealComponent(int n) {
        return this._realComponents[n - 1];
    }

    public final double getFloatComponent(int n) {
        return this.getRealComponent(n);
    }

    public final double setRealComponent(int n, double d) {
        double d2 = d;
        this._realComponents[n - 1] = d2;
        return d2;
    }

    public final double setFloatComponent(int n, double d) {
        return this.setRealComponent(n, d);
    }

    public final Object getObjectComponent(int n) {
        return this._objectComponents[n - 1];
    }

    public final Object setObjectComponent(int n, Object object) {
        Object object2 = object;
        this._objectComponents[n - 1] = object2;
        return object2;
    }

    public final Object getSlicer(int[] nArray) {
        RuntimeTuple runtimeTuple = this;
        int n = nArray.length - 2;
        for (int i = 0; i < n; ++i) {
            runtimeTuple = (RuntimeTuple)runtimeTuple.getObjectComponent(nArray[i]);
        }
        switch (nArray[n + 1]) {
            case 1: {
                return new RuntimeInt(runtimeTuple.getIntComponent(nArray[n]));
            }
            case 2: {
                return new RuntimeReal(runtimeTuple.getRealComponent(nArray[n]));
            }
        }
        return runtimeTuple.getObjectComponent(nArray[n]);
    }

    public final int hashCode() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.intDimension();
        for (n2 = 0; n2 < n6; ++n2) {
            n3 += this._intComponents[n2];
        }
        n2 = this.realDimension();
        for (n = 0; n < n2; ++n) {
            n4 += (int)this._realComponents[n];
        }
        n = this.objectDimension();
        for (int i = 0; i < n; ++i) {
            n5 += this._objectComponents[i].hashCode();
        }
        return 3 * n3 + 5 * n4 + 7 * n5;
    }

    public final boolean equals(Object object) {
        int n;
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuntimeTuple)) {
            return false;
        }
        RuntimeTuple runtimeTuple = (RuntimeTuple)object;
        if (this.intDimension() != runtimeTuple.intDimension()) {
            return false;
        }
        if (this.realDimension() != runtimeTuple.realDimension()) {
            return false;
        }
        if (this.objectDimension() != runtimeTuple.objectDimension()) {
            return false;
        }
        int n2 = this.intDimension();
        for (n = 0; n < n2; ++n) {
            if (this._intComponents[n] == runtimeTuple.intComponents()[n]) continue;
            return false;
        }
        n2 = this.realDimension();
        for (n = 0; n < n2; ++n) {
            if (this._realComponents[n] == runtimeTuple.realComponents()[n]) continue;
            return false;
        }
        n2 = this.objectDimension();
        for (n = 0; n < n2; ++n) {
            if (this._objectComponents[n].equals(runtimeTuple.objectComponents()[n])) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder("<");
        int n2 = this.intDimension();
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(this._intComponents[n] + (n == n2 - 1 ? "" : ","));
        }
        stringBuilder.append("|");
        n2 = this.realDimension();
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(this._realComponents[n] + (n == n2 - 1 ? "" : ","));
        }
        stringBuilder.append("|");
        n2 = this.objectDimension();
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(this._objectComponents[n] + (n == n2 - 1 ? "" : ","));
        }
        return stringBuilder.append(">").toString();
    }
}

