/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Closure;
import hlt.language.design.backend.NullValueException;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Enter;
import hlt.language.design.types.FunctionType;

public class Apply
extends Enter {
    private boolean _LCO_isOff = true;

    protected Apply() {
    }

    public Apply(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setName("APPLY");
    }

    public Apply(FunctionType functionType) {
        super(functionType);
        this.setName("APPLY");
    }

    @Override
    public final Enter setLCO() {
        this.setName("LCO_APPLY");
        this._LCO_isOff = false;
        return this;
    }

    public final Apply curryObject() {
        --this._objectArity;
        --this._arity;
        return this;
    }

    @Override
    public void execute(Runtime runtime) throws NullValueException {
        this._execute((Closure)runtime.popObject("can't apply a null function"), runtime);
    }

    protected final boolean _isVacuous(Closure closure) {
        return super._isVacuous(closure) && this._voidArity == closure.voidArity();
    }

    protected final void _execute(Closure closure, Runtime runtime) throws NullValueException {
        if (this._isVacuous(closure)) {
            runtime.incIP();
            return;
        }
        if (this.trueArity() == closure.trueArity()) {
            if (closure.isExitable()) {
                runtime.enterExitableScope(this._intArity, this._realArity, this._objectArity);
            } else if (this._LCO_isOff) {
                runtime.saveState(this._intArity, this._realArity, this._objectArity);
            }
            runtime.pushIntEnvArray(closure.intFrame());
            runtime.pushRealEnvArray(closure.realFrame());
            runtime.pushObjectEnvArray(closure.objectFrame());
            if (this._arity > 0) {
                int n;
                for (n = 0; n < this._intArity; ++n) {
                    runtime.pushIntEnv(runtime.popInt());
                }
                for (n = 0; n < this._realArity; ++n) {
                    runtime.pushRealEnv(runtime.popReal());
                }
                for (n = 0; n < this._objectArity; ++n) {
                    runtime.pushObjectEnv(runtime.popObject());
                }
            }
            runtime.setCode(closure.code());
            runtime.setIP(closure.address());
        } else {
            int n;
            int[] nArray = closure.intFrame();
            double[] dArray = closure.realFrame();
            Object[] objectArray = closure.objectFrame();
            if (this._intArity <= closure.intArity()) {
                nArray = new int[this._intArity + nArray.length];
                for (n = 0; n < this._intArity; ++n) {
                    nArray[n] = runtime.popInt();
                }
                for (n = this._intArity; n < nArray.length; ++n) {
                    nArray[n] = closure.intFrame()[n - this._intArity];
                }
            }
            if (this._realArity <= closure.realArity()) {
                dArray = new double[this._realArity + dArray.length];
                for (n = 0; n < this._realArity; ++n) {
                    dArray[n] = runtime.popReal();
                }
                for (n = this._realArity; n < dArray.length; ++n) {
                    dArray[n] = closure.realFrame()[n - this._realArity];
                }
            }
            if (this._objectArity <= closure.objectArity()) {
                objectArray = new Object[this._objectArity + objectArray.length];
                for (n = 0; n < this._objectArity; ++n) {
                    objectArray[n] = runtime.popObject();
                }
                for (n = this._objectArity; n < objectArray.length; ++n) {
                    objectArray[n] = closure.objectFrame()[n - this._objectArity];
                }
            }
            runtime.pushObject(new Closure(closure.isExitable(), closure.code(), closure.address(), closure.voidArity() - this._voidArity, closure.intArity() - this._intArity, closure.realArity() - this._realArity, closure.objectArity() - this._objectArity, nArray, dArray, objectArray));
            runtime.incIP();
        }
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Apply)) {
            return false;
        }
        Apply apply = (Apply)object;
        return this._name == apply.name() && this._voidArity == apply.voidArity() && this._intArity == apply.intArity() && this._realArity == apply.realArity() && this._objectArity == apply.objectArity() && this._LCO_isOff == apply.lcoIsOff();
    }
}

