/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.ArrayAllocationErrorException;
import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntMap;
import hlt.language.design.backend.NullValueException;
import hlt.language.design.backend.ObjectMap;
import hlt.language.design.backend.RealMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeMap;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;
import java.lang.reflect.Array;

public class ArrayInitialize
extends Instruction {
    public ArrayInitialize() {
        this.setName("ARRAY_INITIALIZE");
    }

    @Override
    public final void execute(Runtime runtime) throws NullValueException, SizeMatchException, ArrayAllocationErrorException {
        Object object;
        int n = runtime.popInt();
        int n2 = runtime.popInt();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = runtime.popObject("can't allocate a map with a null indexable");
        }
        Object object2 = runtime.objectResult();
        if (object2 != (object = this._checkArray(objectArray, object2, 0, n))) {
            runtime.popObject();
            runtime.pushObject(object);
        }
        runtime.incIP();
    }

    private Object _checkArray(Object[] objectArray, Object object, int n, int n2) {
        if (n >= n2) {
            return this._checkNonExtensionalArray(objectArray, object, n);
        }
        if (object == null) {
            return object;
        }
        if (n == objectArray.length) {
            return object;
        }
        if (objectArray[n] instanceof RuntimeInt) {
            int n3;
            int n4 = ((RuntimeInt)objectArray[n]).value();
            if (n4 != (n3 = Array.getLength(object))) {
                throw new SizeMatchException((Object)("can't initialize an array of size " + n4 + " with an array of size " + n3));
            }
            ++n;
            if (!(object instanceof int[]) && !(object instanceof double[])) {
                Object[] objectArray2 = (Object[])object;
                int n5 = n4;
                while (n5-- > 0) {
                    objectArray2[n5] = this._checkArray(objectArray, objectArray2[n5], n, n2);
                }
            }
            return object;
        }
        Indexable indexable = (Indexable)objectArray[n];
        RuntimeMap runtimeMap = (RuntimeMap)object;
        runtimeMap.trimToSize();
        if (!indexable.equals(runtimeMap.indexable())) {
            throw new ArrayAllocationErrorException((Object)"can't initialize a map from one with a different index set");
        }
        if (!(runtimeMap instanceof IntMap) && !(runtimeMap instanceof RealMap)) {
            Object[] objectArray3 = (Object[])runtimeMap.extractArray();
            ++n;
            int n6 = indexable.size();
            while (n6-- > 0) {
                objectArray3[n6] = this._checkArray(objectArray, objectArray3[n6], n, n2);
            }
        }
        return runtimeMap;
    }

    private Object _checkNonExtensionalArray(Object[] objectArray, Object object, int n) {
        if (object == null) {
            return object;
        }
        if (n == objectArray.length) {
            return object;
        }
        if (objectArray[n] instanceof RuntimeInt) {
            int n2;
            int n3 = ((RuntimeInt)objectArray[n]).value();
            if (n3 != (n2 = Array.getLength(object))) {
                throw new SizeMatchException((Object)("can't initialize an array of size " + n3 + " with an array of size " + n2));
            }
            ++n;
            if (!(object instanceof int[]) && !(object instanceof double[])) {
                Object[] objectArray2 = (Object[])object;
                int n4 = n3;
                while (n4-- > 0) {
                    objectArray2[n4] = this._checkNonExtensionalArray(objectArray, objectArray2[n4], n);
                }
            }
            return object;
        }
        Indexable indexable = (Indexable)objectArray[n];
        if (!(object instanceof RuntimeMap)) {
            int n5;
            int n6 = indexable.size();
            if (n6 != (n5 = Array.getLength(object))) {
                throw new SizeMatchException((Object)("can't initialize a map of size " + n6 + " with an array of size " + n5));
            }
            ++n;
            if (!(object instanceof int[]) && !(object instanceof double[])) {
                Object[] objectArray3 = (Object[])object;
                int n7 = n6;
                while (n7-- > 0) {
                    objectArray3[n7] = this._checkNonExtensionalArray(objectArray, objectArray3[n7], n);
                }
            }
            if (object instanceof int[]) {
                return new IntMap((int[])object, indexable);
            }
            if (object instanceof double[]) {
                return new RealMap((double[])object, indexable);
            }
            return new ObjectMap((Object[])object, indexable);
        }
        RuntimeMap runtimeMap = (RuntimeMap)object;
        runtimeMap.trimToSize();
        int[] nArray = new int[indexable.size()];
        if (!indexable.equals(runtimeMap.indexable(), nArray)) {
            throw new ArrayAllocationErrorException((Object)"can't initialize a map from one with a different index set");
        }
        if (!(runtimeMap instanceof IntMap) && !(runtimeMap instanceof RealMap)) {
            Object[] objectArray4 = (Object[])runtimeMap.extractArray();
            ++n;
            int n8 = indexable.size();
            while (n8-- > 0) {
                objectArray4[n8] = this._checkNonExtensionalArray(objectArray, objectArray4[n8], n);
            }
        }
        if (runtimeMap instanceof IntMap) {
            return new IntMap(this._permute((int[])runtimeMap.extractArray(), nArray), indexable);
        }
        if (runtimeMap instanceof RealMap) {
            return new RealMap(this._permute((double[])runtimeMap.extractArray(), nArray), indexable);
        }
        return new ObjectMap(this._permute((Object[])runtimeMap.extractArray(), nArray), indexable);
    }

    private final int[] _permute(int[] nArray, int[] nArray2) {
        if (this._isTrivial(nArray2)) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length];
        int n = nArray.length;
        while (n-- > 0) {
            nArray3[nArray2[n]] = nArray[n];
        }
        return nArray3;
    }

    private final double[] _permute(double[] dArray, int[] nArray) {
        if (this._isTrivial(nArray)) {
            return dArray;
        }
        double[] dArray2 = new double[dArray.length];
        int n = dArray.length;
        while (n-- > 0) {
            dArray2[nArray[n]] = dArray[n];
        }
        return dArray2;
    }

    private final Object[] _permute(Object[] objectArray, int[] nArray) {
        if (this._isTrivial(nArray)) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray2[nArray[n]] = objectArray[n];
        }
        return objectArray2;
    }

    private final boolean _isTrivial(int[] nArray) {
        int n = nArray.length;
        while (n-- > 0) {
            if (n == nArray[n]) continue;
            return false;
        }
        return true;
    }
}

