/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class CheckArraySize
extends Instruction {
    public CheckArraySize() {
        this.setName("CHECK_ARRAY_SIZE");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException {
        int n = runtime.popInt();
        int n2 = 0;
        if (runtime.objectResult() instanceof RuntimeInt) {
            n2 = ((RuntimeInt)runtime.popObject()).value();
        } else {
            n2 = ((Indexable)runtime.objectResult()).size();
            runtime.pushObject(null);
        }
        if (n != n2) {
            throw new SizeMatchException((Object)("can't initialize an array of size " + n2 + " with an array of size " + n));
        }
        runtime.incIP();
    }
}

