/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Block;
import hlt.language.design.backend.NullValueException;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.types.FunctionType;

public class Enter
extends Instruction {
    protected int _voidArity;
    protected int _intArity;
    protected int _realArity;
    protected int _objectArity;
    protected int _arity;
    protected boolean _LCO_isOff = true;

    protected Enter() {
    }

    public Enter(int n, int n2, int n3, int n4) {
        this.setName("ENTER");
        this._voidArity = n;
        this._intArity = n2;
        this._realArity = n3;
        this._objectArity = n4;
        this._arity = this._intArity + this._realArity + this._objectArity;
    }

    public Enter(FunctionType functionType) {
        this.setName("ENTER");
        block5: for (int i = 0; i < functionType.arity(); ++i) {
            switch (functionType.domain(i).boxSort()) {
                case 1: {
                    ++this._intArity;
                    continue block5;
                }
                case 2: {
                    ++this._realArity;
                    continue block5;
                }
                case 3: {
                    ++this._objectArity;
                    continue block5;
                }
                default: {
                    ++this._voidArity;
                }
            }
        }
        this._arity = this._intArity + this._realArity + this._objectArity;
    }

    public final boolean lcoIsOff() {
        return this._LCO_isOff;
    }

    public Enter setLCO() {
        this.setName("LCO_ENTER");
        this._LCO_isOff = false;
        return this;
    }

    final int voidArity() {
        return this._voidArity;
    }

    final int intArity() {
        return this._intArity;
    }

    final int realArity() {
        return this._realArity;
    }

    final int objectArity() {
        return this._objectArity;
    }

    public final int arity() {
        return this._arity;
    }

    public final int trueArity() {
        return this._arity + this._voidArity;
    }

    @Override
    public void execute(Runtime runtime) throws NullValueException {
        this._execute((Block)runtime.popObject("can't enter a null scope"), runtime);
    }

    protected final boolean _isVacuous(Block block) {
        return this._arity == 0 && block.code()[block.address()].isReturn();
    }

    protected final void _execute(Block block, Runtime runtime) throws NullValueException {
        if (this._isVacuous(block)) {
            runtime.incIP();
            return;
        }
        if (this._LCO_isOff) {
            runtime.saveState(this._intArity, this._realArity, this._objectArity);
        }
        if (this._arity > 0) {
            int n;
            for (n = 0; n < this._intArity; ++n) {
                runtime.pushIntEnv(runtime.popInt());
            }
            for (n = 0; n < this._realArity; ++n) {
                runtime.pushRealEnv(runtime.popReal());
            }
            for (n = 0; n < this._objectArity; ++n) {
                runtime.pushObjectEnv(runtime.popObject());
            }
        }
        runtime.setCode(block.code());
        runtime.setIP(block.address());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Enter)) {
            return false;
        }
        Enter enter = (Enter)object;
        return this._name == enter.name() && this._voidArity == enter.voidArity() && this._intArity == enter.intArity() && this._realArity == enter.realArity() && this._objectArity == enter.objectArity() && this._LCO_isOff == enter.lcoIsOff();
    }

    @Override
    public final String toString() {
        return this._name + "(" + this._voidArity + "," + this._intArity + "," + this._realArity + "," + this._objectArity + ")";
    }
}

