/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushObject;
import hlt.language.design.instructions.PushValue;

public class FillArrayFromIntMap
extends Instruction
implements PushValue,
PushObject {
    public FillArrayFromIntMap() {
        this.setName("FILL_ARRAY_IM");
    }

    @Override
    public final void execute(Runtime runtime) {
        Object[] objectArray = new Object[runtime.popInt()];
        objectArray[0] = runtime.popObject();
        IntMap intMap = (IntMap)objectArray[0];
        int[] nArray = intMap.array();
        Indexable indexable = intMap.indexable();
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray[i] = new IntMap(Runtime.copy(nArray), indexable);
        }
        runtime.pushObject(objectArray);
        runtime.incIP();
    }
}

