/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.ObjectMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushObject;
import hlt.language.design.instructions.PushValue;

public class FillArrayFromObjectMap
extends Instruction
implements PushValue,
PushObject {
    public FillArrayFromObjectMap() {
        this.setName("FILL_ARRAY_OM");
    }

    @Override
    public final void execute(Runtime runtime) {
        Object[] objectArray = new Object[runtime.popInt()];
        objectArray[0] = runtime.popObject();
        ObjectMap objectMap = (ObjectMap)objectArray[0];
        Object[] objectArray2 = objectMap.array();
        Indexable indexable = objectMap.indexable();
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray[i] = new ObjectMap(Runtime.copy(objectArray2), indexable);
        }
        runtime.pushObject(objectArray);
        runtime.incIP();
    }
}

