/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.RealMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushObject;
import hlt.language.design.instructions.PushValue;

public class FillArrayFromRealMap
extends Instruction
implements PushValue,
PushObject {
    public FillArrayFromRealMap() {
        this.setName("FILL_ARRAY_RM");
    }

    @Override
    public final void execute(Runtime runtime) {
        Object[] objectArray = new Object[runtime.popInt()];
        objectArray[0] = runtime.popObject();
        RealMap realMap = (RealMap)objectArray[0];
        double[] dArray = realMap.array();
        Indexable indexable = realMap.indexable();
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray[i] = new RealMap(Runtime.copy(dArray), indexable);
        }
        runtime.pushObject(objectArray);
        runtime.incIP();
    }
}

