/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.ObjectMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushObject;
import hlt.language.design.instructions.PushValue;

public class FillMapFromRealArray
extends Instruction
implements PushValue,
PushObject {
    public FillMapFromRealArray() {
        this.setName("FILL_MAP_RA");
    }

    @Override
    public final void execute(Runtime runtime) {
        Indexable indexable = (Indexable)runtime.popObject();
        Object[] objectArray = new Object[indexable.size()];
        objectArray[0] = runtime.popObject();
        double[] dArray = (double[])objectArray[0];
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray[i] = Runtime.copy(dArray);
        }
        runtime.pushObject(new ObjectMap(objectArray, indexable));
        runtime.incIP();
    }
}

