/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntMap;
import hlt.language.design.backend.NullValueException;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class IntArrayToMap
extends Instruction {
    public IntArrayToMap() {
        this.setName("ARRAY_TO_MAP_I");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException, NullValueException {
        int[] nArray = (int[])runtime.popObject("can't convert a null array to a map");
        Indexable indexable = (Indexable)runtime.popObject("can't make a map with a null indexable");
        if (indexable.size() != nArray.length) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + nArray.length + ")"));
        }
        runtime.pushObject(new IntMap(nArray, indexable));
        runtime.incIP();
    }
}

