/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class MakeIntMap
extends Instruction {
    public MakeIntMap() {
        this.setName("MAKE_MAP_I");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException {
        Indexable indexable = (Indexable)runtime.popObject();
        int n = runtime.popInt();
        if (indexable.size() != n) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + n + ")"));
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = runtime.popInt();
        }
        runtime.pushObject(new IntMap(nArray, indexable));
        runtime.incIP();
    }
}

