/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.RealMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class MakeRealMap
extends Instruction {
    public MakeRealMap() {
        this.setName("MAKE_MAP_R");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException {
        Indexable indexable = (Indexable)runtime.popObject();
        int n = runtime.popInt();
        if (indexable.size() != n) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + n + ")"));
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = runtime.popReal();
        }
        runtime.pushObject(new RealMap(dArray, indexable));
        runtime.incIP();
    }
}

