/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.NullValueException;
import hlt.language.design.backend.ObjectMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class ObjectArrayToMap
extends Instruction {
    public ObjectArrayToMap() {
        this.setName("ARRAY_TO_MAP_O");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException, NullValueException {
        Object[] objectArray = (Object[])runtime.popObject("can't convert a null array to a map");
        Indexable indexable = (Indexable)runtime.popObject("can't make a map with a null indexable");
        if (indexable.size() != objectArray.length) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + objectArray.length + ")"));
        }
        runtime.pushObject(new ObjectMap(objectArray, indexable));
        runtime.incIP();
    }
}

