/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Closure;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Apply;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushScope;
import hlt.language.design.types.CodeEntry;

public class PushClosure
extends PushScope {
    private int _intFrameSize;
    private int _realFrameSize;
    private int _objectFrameSize;
    protected boolean _isExitable = true;

    @Override
    public final boolean isExitable() {
        return this._isExitable;
    }

    public final PushClosure setIsExitable(boolean bl) {
        this._isExitable = bl;
        return this;
    }

    public final PushClosure setNonExitable() {
        this._isExitable = false;
        return this;
    }

    public PushClosure(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4);
        this._intFrameSize = n5;
        this._realFrameSize = n6;
        this._objectFrameSize = n7;
        this.setName("PUSH_CLOSURE");
    }

    public PushClosure(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(n2, n3, n4, n5, n6, n7, n8);
        this.setAddress(n);
    }

    final int intFrameSize() {
        return this._intFrameSize;
    }

    final int realFrameSize() {
        return this._realFrameSize;
    }

    final int objectFrameSize() {
        return this._objectFrameSize;
    }

    public final Instruction apply() {
        return new Apply(this._voidArity, this._intArity, this._realArity, this._objectArity);
    }

    @Override
    public final void execute(Runtime runtime) {
        runtime.pushObject(new Closure(this._isExitable, this._code, this._address, this._voidArity, this._intArity, this._realArity, this._objectArity, runtime.copyIntEnv(this._intFrameSize), runtime.copyRealEnv(this._realFrameSize), runtime.copyObjectEnv(this._objectFrameSize)));
        runtime.incIP();
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PushClosure)) {
            return false;
        }
        PushClosure pushClosure = (PushClosure)object;
        return this._name == pushClosure.name() && this._address == pushClosure.address() && this._voidArity == pushClosure.voidArity() && this._intArity == pushClosure.intArity() && this._realArity == pushClosure.realArity() && this._objectArity == pushClosure.objectArity() && this._intFrameSize == pushClosure.intFrameSize() && this._realFrameSize == pushClosure.realFrameSize() && this._objectFrameSize == pushClosure.objectFrameSize() && this._isExitable == pushClosure.isExitable() && (this._code == null ? pushClosure.code() == null : this._code == pushClosure.code());
    }

    @Override
    public final int hashCode() {
        return this.name().hashCode() + 2 * this._address + (this._code == null ? 0 : 3 * this._code.length) + 5 * this._voidArity + 7 * this._intArity + 11 * this._realArity + 13 * this._objectArity + 17 * this._intFrameSize + 19 * this._realFrameSize + 23 * this._objectFrameSize;
    }

    @Override
    public final String toString() {
        return this.name() + "(" + CodeEntry.getId(this._code) + "," + this._address + ",<" + this._voidArity + "," + this._intArity + "," + this._realArity + "," + this._objectArity + ">,<" + this._intFrameSize + "," + this._realFrameSize + "," + this._objectFrameSize + ">)";
    }
}

