/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Block;
import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushObject;
import hlt.language.design.types.CodeEntry;

public class PushScope
extends Instruction
implements PushObject {
    protected int _address;
    protected int _voidArity;
    protected int _intArity;
    protected int _realArity;
    protected int _objectArity;
    protected Instruction[] _code;

    public PushScope(int n, int n2, int n3, int n4) {
        this.setName("PUSH_SCOPE");
        this._voidArity = n;
        this._intArity = n2;
        this._realArity = n3;
        this._objectArity = n4;
    }

    public PushScope(int n, int n2, int n3, int n4, int n5) {
        this(n, n3, n4, n5);
        this.setAddress(n2);
    }

    public boolean isExitable() {
        return false;
    }

    final int address() {
        return this._address;
    }

    final int voidArity() {
        return this._voidArity;
    }

    final int intArity() {
        return this._intArity;
    }

    final int realArity() {
        return this._realArity;
    }

    final int objectArity() {
        return this._objectArity;
    }

    final Instruction[] code() {
        return this._code;
    }

    public final PushScope setAddress(int n) {
        this._address = n;
        return this;
    }

    public final PushScope setCode(Instruction[] instructionArray) {
        this._code = instructionArray;
        return this;
    }

    public final Instruction setReferenceCode(Instruction[] instructionArray) {
        if (this._code != null) {
            return this;
        }
        this._code = instructionArray;
        return this;
    }

    @Override
    public void execute(Runtime runtime) {
        runtime.pushObject(new Block(this._code, this._address, this._voidArity, this._intArity, this._realArity, this._objectArity));
        runtime.incIP();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PushScope)) {
            return false;
        }
        PushScope pushScope = (PushScope)object;
        return this._name == pushScope.name() && this._address == pushScope.address() && this._voidArity == pushScope.voidArity() && this._intArity == pushScope.intArity() && this._realArity == pushScope.realArity() && this._objectArity == pushScope.objectArity() && (this._code == null ? pushScope.code() == null : this._code == pushScope.code());
    }

    @Override
    public int hashCode() {
        return this._name.hashCode() + 2 * this._address + (this._code == null ? 0 : 3 * this._code.length) + 5 * this._voidArity + 7 * this._intArity + 11 * this._realArity + 13 * this._objectArity;
    }

    @Override
    public String toString() {
        return this._name + "(" + CodeEntry.getId(this._code) + "," + this._address + ",<" + this._voidArity + "," + this._intArity + "," + this._realArity + "," + this._objectArity + ">)";
    }
}

