/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.RuntimeTuple;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushObject;
import hlt.language.design.instructions.PushValue;

public class PushTuple
extends Instruction
implements PushValue,
PushObject {
    private int _intDim;
    private int _realDim;
    private int _objectDim;

    public PushTuple(int n, int n2, int n3) {
        this.setName("PUSH_TUPLE");
        this._intDim = n;
        this._realDim = n2;
        this._objectDim = n3;
    }

    final int intDimension() {
        return this._intDim;
    }

    final int realDimension() {
        return this._realDim;
    }

    final int objectDimension() {
        return this._objectDim;
    }

    @Override
    public final void execute(Runtime runtime) {
        if (this._intDim + this._realDim + this._objectDim == 0) {
            runtime.pushObject(RuntimeTuple.EMPTY);
        } else {
            int n;
            int[] nArray = this._intDim == 0 ? null : new int[this._intDim];
            double[] dArray = this._realDim == 0 ? null : new double[this._realDim];
            Object[] objectArray = this._objectDim == 0 ? null : new Object[this._objectDim];
            for (n = 0; n < this._intDim; ++n) {
                nArray[n] = runtime.popInt();
            }
            for (n = 0; n < this._realDim; ++n) {
                dArray[n] = runtime.popReal();
            }
            for (n = 0; n < this._objectDim; ++n) {
                objectArray[n] = runtime.popObject();
            }
            runtime.pushObject(new RuntimeTuple(nArray, dArray, objectArray));
        }
        runtime.incIP();
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PushTuple)) {
            return false;
        }
        PushTuple pushTuple = (PushTuple)object;
        return this._intDim == pushTuple.intDimension() && this._realDim == pushTuple.realDimension() && this._objectDim == pushTuple.objectDimension();
    }

    @Override
    public final int hashCode() {
        return this.name().hashCode() + 2 * this._intDim + 3 * this._realDim + 5 * this._objectDim;
    }

    @Override
    public final String toString() {
        return this.name() + "(" + this._intDim + "," + this._realDim + "," + this._objectDim + ")";
    }
}

