/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Runtime;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushInt;
import hlt.language.design.instructions.PushValue;

public class PushValueInt
extends Instruction
implements PushValue,
PushInt {
    private int _value;

    public PushValueInt() {
        this.setName("PUSH_I");
    }

    public PushValueInt(int n) {
        this.setName("PUSH_I");
        this._value = n;
    }

    final int value() {
        return this._value;
    }

    final void setValue(int n) {
        this._value = n;
    }

    @Override
    public final void execute(Runtime runtime) {
        runtime.pushInt(this._value);
        runtime.incIP();
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PushValueInt)) {
            return false;
        }
        return this._value == ((PushValueInt)object).value();
    }

    @Override
    public final int hashCode() {
        return this.name().hashCode() + this._value;
    }

    @Override
    public final String toString() {
        return this.name() + "(" + this._value + ")";
    }
}

