/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.NullValueException;
import hlt.language.design.backend.RealMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class RealArrayToMap
extends Instruction {
    public RealArrayToMap() {
        this.setName("ARRAY_TO_MAP_R");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException, NullValueException {
        double[] dArray = (double[])runtime.popObject("can't convert a null array to a map");
        Indexable indexable = (Indexable)runtime.popObject("can't make a map with a null indexable");
        if (indexable.size() != dArray.length) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + dArray.length + ")"));
        }
        runtime.pushObject(new RealMap(dArray, indexable));
        runtime.incIP();
    }
}

