/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.IntMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class ShuffleIntMap
extends Instruction {
    public ShuffleIntMap() {
        this.setName("SHUFFLE_MAP_I");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException {
        int[] nArray = (int[])runtime.popObject();
        Indexable indexable = (Indexable)runtime.popObject();
        int n = runtime.popInt();
        if (indexable.size() != n) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + n + ")"));
        }
        int[] nArray2 = new int[n];
        if (nArray == null) {
            for (int i = 0; i < n; ++i) {
                nArray2[i] = runtime.popInt();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray2[nArray[i]] = runtime.popInt();
            }
        }
        runtime.pushObject(new IntMap(nArray2, indexable));
        runtime.incIP();
    }
}

