/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.ObjectMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class ShuffleObjectMap
extends Instruction {
    public ShuffleObjectMap() {
        this.setName("SHUFFLE_MAP_O");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException {
        int[] nArray = (int[])runtime.popObject();
        Indexable indexable = (Indexable)runtime.popObject();
        int n = runtime.popInt();
        if (indexable.size() != n) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + n + ")"));
        }
        Object[] objectArray = new Object[n];
        if (nArray == null) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = runtime.popObject();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                objectArray[nArray[i]] = runtime.popObject();
            }
        }
        runtime.pushObject(new ObjectMap(objectArray, indexable));
        runtime.incIP();
    }
}

