/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.instructions;

import hlt.language.design.backend.Indexable;
import hlt.language.design.backend.RealMap;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.SizeMatchException;
import hlt.language.design.instructions.Instruction;

public class ShuffleRealMap
extends Instruction {
    public ShuffleRealMap() {
        this.setName("SHUFFLE_MAP_R");
    }

    @Override
    public final void execute(Runtime runtime) throws SizeMatchException {
        int[] nArray = (int[])runtime.popObject();
        Indexable indexable = (Indexable)runtime.popObject();
        int n = runtime.popInt();
        if (indexable.size() != n) {
            throw new SizeMatchException((Object)("indexable size (" + indexable.size() + ") does not match array size (" + n + ")"));
        }
        double[] dArray = new double[n];
        if (nArray == null) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = runtime.popReal();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[nArray[i]] = runtime.popReal();
            }
        }
        runtime.pushObject(new RealMap(dArray, indexable));
        runtime.incIP();
    }
}

