/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.PushClosure;
import hlt.language.design.instructions.PushScope;
import hlt.language.design.kernel.Enclosure;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Local;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.Scope;
import hlt.language.design.types.PopExitableGoal;
import hlt.language.design.types.PushExitableGoal;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import hlt.language.util.ObjectToIntMap;
import java.util.AbstractList;
import java.util.Iterator;

public class Abstraction
extends Scope {
    protected boolean _isExitable = true;
    private ObjectToIntMap _frame = new ObjectToIntMap();
    private int _intFrameSize = 0;
    private int _realFrameSize = 0;
    private int _objectFrameSize = 0;

    public Abstraction(Parameter[] parameterArray, Expression expression) {
        super(parameterArray, expression);
    }

    public Abstraction(Parameter parameter, Expression expression) {
        super(parameter, expression);
    }

    public Abstraction(String string, Expression expression) {
        super(string, expression);
    }

    public Abstraction(Expression expression) {
        super(expression);
    }

    public Abstraction(AbstractList abstractList, Expression expression) {
        super(abstractList, expression);
    }

    @Override
    public final Expression copy() {
        Parameter[] parameterArray = new Parameter[this._parameters.length];
        int n = parameterArray.length;
        while (n-- > 0) {
            parameterArray[n] = (Parameter)this._parameters[n].copy();
        }
        return new Abstraction(parameterArray, this._body.copy()).setIsExitable(this._isExitable);
    }

    @Override
    public final Expression typedCopy() {
        Parameter[] parameterArray = new Parameter[this._parameters.length];
        int n = parameterArray.length;
        while (n-- > 0) {
            parameterArray[n] = (Parameter)this._parameters[n].typedCopy();
        }
        return new Abstraction(parameterArray, this._body.typedCopy()).setIsExitable(this._isExitable).addTypes(this);
    }

    @Override
    protected final void _flatten() {
        if (this._body instanceof Abstraction) {
            Parameter[] parameterArray = ((Abstraction)this._body).parameters();
            Parameter[] parameterArray2 = new Parameter[this._parameters.length + parameterArray.length];
            int n = this._parameters.length;
            while (n-- > 0) {
                parameterArray2[n] = this._parameters[n];
            }
            for (n = this._parameters.length; n < parameterArray2.length; ++n) {
                parameterArray2[n] = parameterArray[n - this._parameters.length];
            }
            this._parameters = parameterArray2;
            this._isExitable = ((Abstraction)this._body).isExitable();
            this._body = ((Abstraction)this._body).body();
        }
    }

    public final boolean isExitable() {
        return this._isExitable;
    }

    public final Scope setIsExitable(boolean bl) {
        this._isExitable = bl;
        return this;
    }

    public final Scope setNonExitable() {
        this._isExitable = false;
        return this;
    }

    public final void addToFrame(Local local) {
        this._frame.put(local, local.offset());
    }

    @Override
    public final void sanitizeSorts(Enclosure enclosure) {
        if (this._isSortSanitized) {
            return;
        }
        enclosure.push(this);
        this._body.sanitizeSorts(enclosure);
        enclosure.pop();
        Iterator iterator = this._frame.keys();
        while (iterator.hasNext()) {
            Local local = (Local)iterator.next();
            switch (local.boxSort()) {
                case 1: {
                    this._intFrameSize = this._maxFrameSize(local, this._intFrameSize);
                    break;
                }
                case 2: {
                    this._realFrameSize = this._maxFrameSize(local, this._realFrameSize);
                    break;
                }
                case 3: {
                    this._objectFrameSize = this._maxFrameSize(local, this._objectFrameSize);
                }
            }
        }
        this._frame = null;
        this._isSortSanitized = true;
    }

    private final int _maxFrameSize(Local local, int n) {
        return Math.max(n, local.offset() - this._frame.get(local));
    }

    @Override
    public final Expression shiftOffsets(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        if (bl |= this._intFrameSize > 0) {
            this._intFrameSize += n;
        }
        if (bl |= this._realFrameSize > 0) {
            this._realFrameSize += n2;
        }
        if (bl |= this._objectFrameSize > 0) {
            this._objectFrameSize += n3;
        }
        if (bl) {
            this._body = this._body.shiftOffsets(n, n2, n3, n4 + this._intArity, n5 + this._realArity, n6 + this._objectArity);
        }
        return this;
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        if (this._isExitable) {
            typeChecker.prove(new PushExitableGoal(this));
        }
        this._typeCheckLocked = false;
        super.typeCheck(typeChecker);
        if (this._isExitable) {
            typeChecker.prove(new PopExitableGoal(this));
        }
    }

    @Override
    protected final PushScope _pushInstruction() {
        return new PushClosure(this.voidArity(), this._intArity, this._realArity, this._objectArity, this._intFrameSize, this._realFrameSize, this._objectFrameSize).setIsExitable(this._isExitable);
    }

    @Override
    public final String toString() {
        Object object = "function";
        object = (String)object + "(";
        for (int i = 0; i < this.arity(); ++i) {
            object = (String)object + this._parameters[i];
            if (i >= this.arity() - 1) continue;
            object = (String)object + ",";
        }
        return (String)object + ") " + this._body;
    }
}

