/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import hlt.language.tools.Misc;

public abstract class AndOr
extends Expression {
    Type _type = Type.BOOLEAN();
    protected Expression _left;
    protected Expression _rite;

    public AndOr(Expression expression, Expression expression2) {
        this._left = expression;
        this._rite = expression2;
    }

    public final Expression left() {
        return this._left;
    }

    public final Expression right() {
        return this._rite;
    }

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._left;
            }
            case 1: {
                return this._rite;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._left = expression;
                break;
            }
            case 1: {
                this._rite = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    @Override
    public abstract void compile(Compiler var1);

    @Override
    public final void setType(Type type) {
        throw new UnsupportedOperationException("setType(Type) in class " + Misc.simpleClassName(this));
    }

    @Override
    public final Type type() {
        return this._type.value();
    }

    @Override
    public final Type typeRef() {
        return this._type;
    }

    @Override
    public final Type checkedType() {
        return this._type;
    }

    @Override
    public final void setCheckedType(Type type) {
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._left.setCheckedType();
        this._rite.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._left.typeCheck(Type.BOOLEAN(), typeChecker);
        this._rite.typeCheck(Type.BOOLEAN(), typeChecker);
    }
}

