/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Apply;
import hlt.language.design.instructions.Enter;
import hlt.language.design.instructions.FieldInstruction;
import hlt.language.design.instructions.GetIntField;
import hlt.language.design.instructions.GetObjectField;
import hlt.language.design.instructions.GetRealField;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.StringConcatenation;
import hlt.language.design.instructions.WriteInt;
import hlt.language.design.instructions.WriteObject;
import hlt.language.design.kernel.Abstraction;
import hlt.language.design.kernel.And;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Constant;
import hlt.language.design.kernel.Dummy;
import hlt.language.design.kernel.DummyLocal;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.Local;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.Or;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.kernel.Scope;
import hlt.language.design.kernel.TupleProjection;
import hlt.language.design.kernel.UndefinedEqualityException;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.BuiltinEntry;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.SetType;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class Application
extends ProtoExpression {
    protected Expression _function;
    protected Expression[] _arguments;
    protected Expression _checkedFunction;
    protected Expression[] _checkedArguments;
    protected boolean _noCurrying = false;

    protected Application() {
    }

    public Application(Expression expression, Expression[] expressionArray) {
        this._function = expression;
        this._arguments = expressionArray;
    }

    public Application(Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2, expression3};
        this._function = expression;
        this._arguments = expressionArray;
    }

    public Application(Expression expression, Expression expression2) {
        this._function = expression;
        this._arguments = new Expression[1];
        this._arguments[0] = expression2;
    }

    public Application(Expression expression, AbstractList abstractList) {
        this._function = expression;
        if (!abstractList.isEmpty()) {
            this._arguments = new Expression[abstractList.size()];
            int n = this._arguments.length;
            while (n-- > 0) {
                this._arguments[n] = (Expression)abstractList.get(n);
            }
        } else {
            this._arguments = new Expression[1];
            this._arguments[0] = Constant.VOID;
        }
    }

    public final Application flatten() {
        if (!this._noCurrying && this._function instanceof Application) {
            int n;
            Application application = (Application)this._function;
            int n2 = application.arity();
            Expression[] expressionArray = new Expression[n2 + this._arguments.length];
            for (n = 0; n < n2; ++n) {
                expressionArray[n] = application.argument(n);
            }
            for (n = n2; n < expressionArray.length; ++n) {
                expressionArray[n] = this._arguments[n - n2];
            }
            this._function = application.function();
            this._arguments = expressionArray;
        }
        return this;
    }

    @Override
    public final Expression copy() {
        Expression[] expressionArray = new Expression[this._arguments.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._arguments[n].copy();
        }
        return new Application(this._function.copy(), expressionArray);
    }

    @Override
    public final Expression typedCopy() {
        Expression[] expressionArray = new Expression[this._arguments.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._arguments[n].typedCopy();
        }
        return new Application(this._function.typedCopy(), expressionArray).addTypes(this);
    }

    @Override
    public final boolean isSlicing(Tables tables, Parameter parameter) throws UndefinedEqualityException {
        if (!this._function.isEquality(tables) || this.arity() != 2) {
            return false;
        }
        if (this._arguments[0] instanceof TupleProjection && !this._arguments[1].containsFreeName(parameter.name()) && ((TupleProjection)this._arguments[0]).slicesParameter(parameter)) {
            return true;
        }
        if (this._arguments[1] instanceof TupleProjection && !this._arguments[0].containsFreeName(parameter.name()) && ((TupleProjection)this._arguments[1]).slicesParameter(parameter)) {
            Expression expression = this._arguments[0];
            this._arguments[0] = this._arguments[1];
            this._arguments[1] = expression;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isHiddenSlicing(Tables tables, Parameter parameter) throws UndefinedEqualityException {
        if (!this._function.isEquality(tables) || this.arity() != 2) {
            return false;
        }
        if (this._arguments[0] instanceof Application && ((Application)this._arguments[0]).isUnaryTupleProjection() && ((Application)this._arguments[0]).slicesParameter(parameter) && !this._arguments[1].containsFreeName(parameter.name())) {
            this._arguments[0] = ((Application)this._arguments[0]).rebuildTupleProjection();
            return true;
        }
        if (this._arguments[1] instanceof Application && ((Application)this._arguments[1]).isUnaryTupleProjection() && ((Application)this._arguments[1]).slicesParameter(parameter) && !this._arguments[0].containsFreeName(parameter.name())) {
            Expression expression = this._arguments[0];
            this._arguments[0] = ((Application)this._arguments[1]).rebuildTupleProjection();
            this._arguments[1] = expression;
            return true;
        }
        return false;
    }

    public final boolean slicesParameter(Parameter parameter) {
        if (this._arguments[0] instanceof Application && ((Application)this._arguments[0]).isUnaryTupleProjection()) {
            return ((Application)this._arguments[0]).slicesParameter(parameter);
        }
        if (this._arguments[0] instanceof Local) {
            return ((Local)this._arguments[0]).name() == parameter.name();
        }
        return false;
    }

    final TupleProjection rebuildTupleProjection() {
        TupleProjection tupleProjection = null;
        Expression expression = null;
        String string = ((Global)this.function()).name();
        if (this._arguments[0] instanceof Local) {
            expression = new DummyLocal(((Local)this._arguments[0]).parameter());
            ((Local)expression).parameter().setType(this._arguments[0].type().actualType());
        } else {
            expression = ((Application)this._arguments[0]).rebuildTupleProjection();
            ((Expression)expression).setType(this._arguments[0].type().actualType());
        }
        tupleProjection = new TupleProjection(expression, string);
        tupleProjection.setPosition(string);
        tupleProjection.setType(this.type().actualType());
        return tupleProjection;
    }

    @Override
    public final boolean isSelector(Tables tables, Parameter parameter) throws UndefinedEqualityException {
        if (!this._function.isEquality(tables) || this.arity() != 2) {
            return false;
        }
        if (this._arguments[0] instanceof Dummy && !this._arguments[1].containsFreeName(parameter.name())) {
            return true;
        }
        if (this._arguments[1] instanceof Dummy && !this._arguments[0].containsFreeName(parameter.name())) {
            Expression expression = this._arguments[0];
            this._arguments[0] = this._arguments[1];
            this._arguments[1] = expression;
            return true;
        }
        return false;
    }

    public final Expression undoDummyLocal() {
        TupleProjection tupleProjection = (TupleProjection)this._arguments[0];
        while (tupleProjection.tuple() instanceof TupleProjection) {
            tupleProjection = (TupleProjection)tupleProjection.tuple();
        }
        DummyLocal dummyLocal = (DummyLocal)tupleProjection.tuple();
        tupleProjection.setSubexpression(0, new Dummy(dummyLocal.name()).addTypes(dummyLocal));
        return this;
    }

    public final boolean noCurrying() {
        return this._noCurrying;
    }

    public final Application setNoCurrying() {
        return this.setNoCurrying(true);
    }

    public final Application setNoCurrying(boolean bl) {
        this._noCurrying = bl;
        return this;
    }

    @Override
    public int numberOfSubexpressions() {
        return this._arguments.length + 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n == 0) {
            return this._function;
        }
        if (n > 0 && n <= this._arguments.length) {
            return this._arguments[n - 1];
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n == 0) {
            this._function = expression;
        } else if (n > 0 && n <= this._arguments.length) {
            this._arguments[n - 1] = expression;
        } else {
            throw new NoSuchSubexpressionException(this, n);
        }
        return this;
    }

    public final Expression function() {
        return this._checkedFunction == null ? this._function : this._checkedFunction;
    }

    public final Expression[] arguments() {
        return this._checkedArguments == null ? this._arguments : this._checkedArguments;
    }

    public final Expression argument(int n) {
        return this.arguments()[n];
    }

    public final void setFunction(Expression expression) {
        this._function = expression;
    }

    public final void setArguments(Expression[] expressionArray) {
        this._arguments = expressionArray;
    }

    public final int arity() {
        return this.arguments().length;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._function.setCheckedType();
        int n = this._arguments.length;
        while (n-- > 0) {
            this._arguments[n].setCheckedType();
        }
        this.setCheckedType(this.type().copy());
    }

    @Override
    public final void setCheckedType(Type type) {
        this._checkedFunction = this._function;
        this._checkedArguments = this._arguments;
        this._checkedType = type;
    }

    @Override
    public final void typeCheck(Type type, TypeChecker typeChecker) throws TypingErrorException {
        this.typeCheck(typeChecker);
        typeChecker.unify(this._type, type, this);
    }

    @Override
    public void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        Type[] typeArray = new Type[this.arity()];
        int n = this.arity();
        while (n-- > 0) {
            this._arguments[n].typeCheck(typeChecker);
            typeArray[n] = this._arguments[n].typeRef();
        }
        FunctionType functionType = new FunctionType(typeArray, this._type).setNoCurrying(this._noCurrying);
        this._function.typeCheck(functionType, typeChecker);
        int n2 = ((FunctionType)this._function.type()).arity();
        if (n2 < this.arity()) {
            this._curryTypeCheck(n2, typeChecker);
        }
    }

    protected final void _curryTypeCheck(int n, TypeChecker typeChecker) throws TypingErrorException {
        Expression[] expressionArray = new Expression[n];
        int n2 = n;
        while (n2-- > 0) {
            expressionArray[n2] = this._arguments[n2];
        }
        Expression[] expressionArray2 = new Expression[this.arity() - n];
        int n3 = expressionArray2.length;
        while (n3-- > 0) {
            expressionArray2[n3] = this._arguments[n3 + n];
        }
        typeChecker.trail(this, this._function, this._arguments);
        this._function = new Application(this._function, expressionArray);
        this._arguments = expressionArray2;
        this._typeCheckLocked = false;
        this.typeCheck(typeChecker);
    }

    public final boolean isTupleProjection() {
        return this.function() instanceof Global && ((Global)this.function()).codeEntry().isProjection();
    }

    public final boolean isUnaryTupleProjection() {
        return this.isTupleProjection() && this.arity() == 1;
    }

    public final boolean isFieldApplication() {
        return this.function() instanceof Global && ((Global)this.function()).codeEntry().isField();
    }

    @Override
    public void compile(Compiler compiler) {
        FunctionType functionType = (FunctionType)this._checkedFunction.checkedType();
        if (this._compileBuiltIn(functionType, compiler)) {
            return;
        }
        int n = this._checkedArguments.length;
        while (n-- > 0) {
            this._compileArgument(n, functionType, compiler);
        }
        if (this.isFieldApplication()) {
            DefinedEntry definedEntry = ((Global)this._checkedFunction).definedEntry();
            compiler.generate(this._getField(definedEntry));
            if (this.arity() > 1) {
                compiler.generate(new Apply(functionType).curryObject());
            }
        } else if (this.isTupleProjection()) {
            DefinedEntry definedEntry = ((Global)this._checkedFunction).definedEntry();
            compiler.generate(definedEntry.projection());
            if (this.arity() > 1) {
                compiler.generate(new Apply(functionType).curryObject());
            }
        } else {
            this._checkedFunction.compile(compiler);
            compiler.generate(this._checkedFunction instanceof Scope ? new Enter(functionType) : new Apply(functionType));
        }
        this._padResultIfNeeded(functionType, compiler);
    }

    protected final FieldInstruction _getField(DefinedEntry definedEntry) {
        switch (definedEntry.fieldSort()) {
            case 1: {
                return new GetIntField(definedEntry);
            }
            case 2: {
                return new GetRealField(definedEntry);
            }
            case 3: {
                return new GetObjectField(definedEntry);
            }
        }
        return null;
    }

    protected final boolean _compileBuiltIn(FunctionType functionType, Compiler compiler) {
        CodeEntry codeEntry;
        if (this._checkedFunction instanceof Global && (codeEntry = ((Global)this._checkedFunction).checkedCodeEntry()).isBuiltIn()) {
            BuiltinEntry builtinEntry = (BuiltinEntry)codeEntry;
            Instruction instruction = builtinEntry.builtIn();
            FunctionType functionType2 = (FunctionType)codeEntry.type().copy();
            if (this._checkedArguments.length == functionType2.arity()) {
                if (instruction.isDummy()) {
                    return this._compileDummyBuiltin(instruction, functionType, compiler);
                }
                for (int i = this._checkedArguments.length - 1; i >= 0; --i) {
                    this._checkedArguments[i].compile(compiler);
                    this._padArgumentIfNeeded(i, functionType, compiler);
                }
                compiler.generate(instruction);
                this._padResultIfNeeded(functionType, compiler);
            } else {
                this._compileCurryedBuiltIn(functionType, compiler);
            }
            return true;
        }
        return false;
    }

    protected boolean _compileDummyBuiltin(Instruction instruction, FunctionType functionType, Compiler compiler) {
        if (instruction == Instruction.DUMMY_AND) {
            And and = new And(this._checkedArguments[0], this._checkedArguments[1]);
            and.setCheckedType(this.checkedType());
            and.compile(compiler);
            return true;
        }
        if (instruction == Instruction.DUMMY_OR) {
            Or or = new Or(this._checkedArguments[0], this._checkedArguments[1]);
            or.setCheckedType(this.checkedType());
            or.compile(compiler);
            return true;
        }
        if (instruction == Instruction.DUMMY_SIZE) {
            this._checkedArguments[0].compile(compiler);
            if (((ArrayType)this._checkedArguments[0].checkedType()).isMap()) {
                compiler.generate(Instruction.MAP_SIZE);
            } else {
                compiler.generate(Instruction.ARRAY_SIZE);
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_EQU || instruction == Instruction.DUMMY_NEQ) {
            if (this._checkedArguments[1].sort() == 0) {
                if (instruction == Instruction.DUMMY_EQU) {
                    compiler.generate(Instruction.PUSH_TRUE);
                } else {
                    compiler.generate(Instruction.PUSH_FALSE);
                }
            } else {
                this._checkedArguments[1].compile(compiler);
                if (this._checkedArguments[1].checkedType().isBoxedType() && (this._checkedArguments[1].sort() == 1 || this._checkedArguments[1].sort() == 2)) {
                    compiler.generateUnwrapper(this._checkedArguments[1].sort());
                }
                this._checkedArguments[0].compile(compiler);
                if (this._checkedArguments[0].checkedType().isBoxedType() && (this._checkedArguments[0].sort() == 1 || this._checkedArguments[0].sort() == 2)) {
                    compiler.generateUnwrapper(this._checkedArguments[0].sort());
                }
                if (instruction == Instruction.DUMMY_EQU) {
                    switch (this._checkedArguments[0].sort()) {
                        case 1: {
                            compiler.generate(Instruction.EQU_II);
                            break;
                        }
                        case 2: {
                            compiler.generate(Instruction.EQU_RR);
                            break;
                        }
                        default: {
                            compiler.generate(Instruction.EQU_OO);
                            break;
                        }
                    }
                } else {
                    switch (this._checkedArguments[0].sort()) {
                        case 1: {
                            compiler.generate(Instruction.NEQ_II);
                            break;
                        }
                        case 2: {
                            compiler.generate(Instruction.NEQ_RR);
                            break;
                        }
                        default: {
                            compiler.generate(Instruction.NEQ_OO);
                        }
                    }
                }
            }
            this._padResultIfNeeded(functionType, compiler);
            return true;
        }
        if (instruction == Instruction.DUMMY_STRCON) {
            this._checkedArguments[1].compile(compiler);
            this._compileArgument(0, functionType, compiler);
            compiler.generate(new StringConcatenation(this._checkedArguments[0].checkedType()));
            return true;
        }
        if (instruction == Instruction.DUMMY_WRITE) {
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[0].boxSort()) {
                case 1: {
                    compiler.generate(new WriteInt(this._checkedArguments[0].checkedType()));
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.WRITE_R);
                    break;
                }
                default: {
                    compiler.generate(new WriteObject(this._checkedArguments[0].checkedType()));
                }
            }
            this._padResultIfNeeded(functionType, compiler);
            return true;
        }
        if (instruction == Instruction.DUMMY_SET_ADD || instruction == Instruction.DUMMY_SET_RMV) {
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[0].boxSort()) {
                case 1: {
                    compiler.generate(instruction == Instruction.DUMMY_SET_ADD ? Instruction.SET_ADD_I : Instruction.SET_RMV_I);
                    break;
                }
                case 2: {
                    compiler.generate(instruction == Instruction.DUMMY_SET_ADD ? Instruction.SET_ADD_R : Instruction.SET_RMV_R);
                    break;
                }
                default: {
                    compiler.generate(instruction == Instruction.DUMMY_SET_ADD ? Instruction.SET_ADD_O : Instruction.SET_RMV_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_BELONGS) {
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[0].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.BELONGS_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.BELONGS_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.BELONGS_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_FIRST) {
            this._checkedArguments[0].compile(compiler);
            switch (((SetType)this._checkedArguments[0].checkedType()).baseType().boxSort()) {
                case 1: {
                    compiler.generate(Instruction.FIRST_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.FIRST_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.FIRST_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_LAST) {
            this._checkedArguments[0].compile(compiler);
            switch (((SetType)this._checkedArguments[0].checkedType()).baseType().boxSort()) {
                case 1: {
                    compiler.generate(Instruction.LAST_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.LAST_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.LAST_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_ORD) {
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.ORD_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.ORD_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.ORD_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_NEXT) {
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.NEXT_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.NEXT_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.NEXT_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_NEXT_OFFSET) {
            this._checkedArguments[2].compile(compiler);
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.NEXT_I_OFFSET);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.NEXT_R_OFFSET);
                    break;
                }
                default: {
                    compiler.generate(Instruction.NEXT_O_OFFSET);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_NEXT_C) {
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.NEXT_C_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.NEXT_C_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.NEXT_C_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_NEXT_C_OFFSET) {
            this._checkedArguments[2].compile(compiler);
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.NEXT_C_I_OFFSET);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.NEXT_C_R_OFFSET);
                    break;
                }
                default: {
                    compiler.generate(Instruction.NEXT_C_O_OFFSET);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_PREV) {
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.PREV_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.PREV_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.PREV_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_PREV_OFFSET) {
            this._checkedArguments[2].compile(compiler);
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.PREV_I_OFFSET);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.PREV_R_OFFSET);
                    break;
                }
                default: {
                    compiler.generate(Instruction.PREV_O_OFFSET);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_PREV_C) {
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.PREV_C_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.PREV_C_R);
                    break;
                }
                default: {
                    compiler.generate(Instruction.PREV_C_O);
                }
            }
            return true;
        }
        if (instruction == Instruction.DUMMY_PREV_C_OFFSET) {
            this._checkedArguments[2].compile(compiler);
            this._checkedArguments[1].compile(compiler);
            this._checkedArguments[0].compile(compiler);
            switch (this._checkedArguments[1].boxSort()) {
                case 1: {
                    compiler.generate(Instruction.PREV_C_I_OFFSET);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.PREV_C_R_OFFSET);
                    break;
                }
                default: {
                    compiler.generate(Instruction.PREV_C_O_OFFSET);
                }
            }
            return true;
        }
        return true;
    }

    protected final void _compileArgument(int n, FunctionType functionType, Compiler compiler) {
        if (functionType.domain(n).kind() == 3) {
            this._checkedArguments[n].pad((FunctionType)functionType.domain(n)).compile(compiler);
        } else {
            this._checkedArguments[n].compile(compiler);
        }
        this._padArgumentIfNeeded(n, functionType, compiler);
    }

    protected final void _padArgumentIfNeeded(int n, FunctionType functionType, Compiler compiler) {
        if (functionType.domainIsBoxed(n)) {
            if (!this._checkedArguments[n].checkedType().isBoxedType()) {
                compiler.generateWrapper(this._checkedArguments[n].sort());
            }
        } else if (this._checkedArguments[n].checkedType().isBoxedType()) {
            compiler.generateUnwrapper(this._checkedArguments[n].sort());
        }
    }

    protected final void _padResultIfNeeded(FunctionType functionType, Compiler compiler) {
        if (functionType.rangeIsBoxed()) {
            if (!this._checkedType.isBoxedType()) {
                compiler.generateUnwrapper(this.sort());
            }
        } else if (this._checkedType.isBoxedType()) {
            compiler.generateWrapper(this.sort());
        }
    }

    protected final void _compileCurryedBuiltIn(FunctionType functionType, Compiler compiler) {
        int n;
        FunctionType functionType2 = (FunctionType)functionType.range();
        FunctionType functionType3 = functionType.uncurry();
        int n2 = functionType.arity();
        int n3 = functionType2.arity();
        int n4 = n2 + n3;
        Parameter[] parameterArray = new Parameter[n3];
        Local[] localArray = new Local[n3];
        Expression[] expressionArray = new Expression[n4];
        for (int i = 0; i < n3; ++i) {
            parameterArray[i] = new Parameter();
            parameterArray[i].setCheckedType(functionType2.domain(i));
            localArray[i] = new Local(parameterArray[i]);
        }
        ((Global)this._checkedFunction).resetCheckedType(functionType3);
        Application application = new Application(this._checkedFunction, expressionArray);
        application.setCheckedType(functionType2.range());
        Abstraction abstraction = new Abstraction(parameterArray, (Expression)application);
        abstraction.setNonExitable();
        abstraction.setSortedArities();
        int n5 = abstraction.intArity();
        int n6 = abstraction.realArity();
        int n7 = abstraction.objectArity();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n = 0; n < n3; ++n) {
            switch (parameterArray[n].boxSort()) {
                case 1: {
                    localArray[n].setOffset(n5 - 1 - n8++);
                    break;
                }
                case 2: {
                    localArray[n].setOffset(n6 - 1 - n9++);
                    break;
                }
                default: {
                    localArray[n].setOffset(n7 - 1 - n10++);
                }
            }
            expressionArray[n2 + n] = localArray[n];
        }
        for (n = 0; n < n2; ++n) {
            expressionArray[n] = this._checkedArguments[n].shiftOffsets(n8, n9, n10);
        }
        abstraction.compile(compiler);
    }

    public String toString() {
        String string = this.function() + "(";
        for (int i = 0; i < this.arity(); ++i) {
            string = string + this.argument(i);
            if (i >= this.arity() - 1) continue;
            string = string + ",";
        }
        return string + ")";
    }
}

