/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushValueInt;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.NewSet;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.BaseTypeGoal;
import hlt.language.design.types.SetType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import hlt.language.design.types.UnifyBaseTypeGoal;
import java.util.AbstractList;

public class ArrayExtension
extends ProtoExpression {
    private Expression[] _elements;
    private Expression _indexable;
    private Expression _indexSet;

    public ArrayExtension(AbstractList abstractList, AbstractList abstractList2) {
        if (abstractList != null) {
            this._elements = new Expression[abstractList.size()];
            int n = this._elements.length;
            while (n-- > 0) {
                this._elements[n] = (Expression)abstractList.get(n);
            }
            if (abstractList2 != null) {
                this._indexable = new NewSet(abstractList2).setExtent(this);
            }
        }
    }

    private ArrayExtension(Expression[] expressionArray, Expression expression, Expression expression2) {
        this._elements = expressionArray;
        this._indexable = expression;
        this._indexSet = expression2;
    }

    @Override
    public final Expression copy() {
        Expression[] expressionArray = new Expression[this._elements.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._elements[n].copy();
        }
        Expression expression = this._indexable == null ? null : this._indexable.copy();
        Expression expression2 = this._indexSet == null ? null : this._indexSet.copy();
        return new ArrayExtension(expressionArray, expression, expression2);
    }

    @Override
    public final Expression typedCopy() {
        Expression[] expressionArray = new Expression[this._elements.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._elements[n].typedCopy();
        }
        Expression expression = this._indexable == null ? null : this._indexable.typedCopy();
        Expression expression2 = this._indexSet == null ? null : this._indexSet.typedCopy();
        return new ArrayExtension(expressionArray, expression, expression2);
    }

    public final void setIndexSet(Expression expression) {
        this._indexSet = expression;
    }

    public final int size() {
        return this._elements == null ? 0 : this._elements.length;
    }

    @Override
    public final int numberOfSubexpressions() {
        return this.size() + (this._indexable == null ? 0 : 1) + (this._indexSet == null ? 0 : 1);
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (0 <= n && n < this.size()) {
            return this._elements[n];
        }
        if (n == this.size()) {
            if (this._indexable != null) {
                return this._indexable;
            }
            if (this._indexSet != null) {
                return this._indexSet;
            }
            throw new NoSuchSubexpressionException(this, n);
        }
        if (n == this.size() + 1 && this._indexSet != null) {
            return this._indexSet;
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (0 <= n && n < this.size()) {
            this._elements[n] = expression;
            return this;
        } else if (n == this.size()) {
            if (this._indexable != null) {
                this._indexable = expression;
                return this;
            } else {
                if (this._indexSet == null) throw new NoSuchSubexpressionException(this, n);
                this._indexSet = expression;
            }
            return this;
        } else {
            if (n != this.size() + 1 || this._indexSet == null) throw new NoSuchSubexpressionException(this, n);
            this._indexSet = expression;
        }
        return this;
    }

    public final Expression[] elements() {
        return this._elements;
    }

    public final Expression indexable() {
        return this._indexable;
    }

    public final Expression indexSet() {
        return this._indexSet;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        int n = this.size();
        while (n-- > 0) {
            this._elements[n].setCheckedType();
        }
        if (this._indexable != null) {
            this._indexable.setCheckedType();
        }
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        TypeParameter typeParameter = new TypeParameter();
        TypeParameter typeParameter2 = new TypeParameter();
        int n = this.size();
        while (n-- > 0) {
            this._elements[n].typeCheck(typeParameter, typeChecker);
        }
        if (this._indexable == null) {
            typeChecker.unify(typeParameter2, Type.INT(), this);
        } else {
            this._indexable.typeCheck(new SetType(), typeChecker);
            typeChecker.unify(this._indexable.typeRef(), typeParameter2, this);
        }
        if (this._indexSet != null) {
            this._indexSet.typeCheck((Global)Global.dummyIndexSet().setExtent(this), typeChecker);
            if (this._indexable != null) {
                TypeParameter typeParameter3 = new TypeParameter();
                typeChecker.prove(new UnifyBaseTypeGoal(this._indexable.typeRef(), typeParameter3, this));
                typeChecker.prove(new BaseTypeGoal(this._indexSet, typeParameter3));
            }
        }
        typeChecker.typeCheck(this, new ArrayType(typeParameter, typeParameter2));
    }

    @Override
    public final void compile(Compiler compiler) {
        int n = this.size();
        while (n-- > 0) {
            this._elements[n].compile(compiler);
        }
        compiler.generate(new PushValueInt(this.size()));
        if (this._indexSet == null) {
            if (this._indexable == null) {
                switch (((ArrayType)this._checkedType).baseType().boxSort()) {
                    case 1: {
                        compiler.generate(Instruction.MAKE_ARRAY_I);
                        return;
                    }
                    case 2: {
                        compiler.generate(Instruction.MAKE_ARRAY_R);
                        return;
                    }
                    case 3: {
                        compiler.generate(Instruction.MAKE_ARRAY_O);
                        return;
                    }
                }
            }
            this._indexable.compile(compiler);
            switch (((ArrayType)this._checkedType).baseType().boxSort()) {
                case 1: {
                    compiler.generate(Instruction.MAKE_MAP_I);
                    return;
                }
                case 2: {
                    compiler.generate(Instruction.MAKE_MAP_R);
                    return;
                }
                case 3: {
                    compiler.generate(Instruction.MAKE_MAP_O);
                    return;
                }
            }
        }
        this._indexSet.compile(compiler);
        if (this._indexable == null) {
            if (this._indexSet.checkedType().boxSort() == 1) {
                compiler.generate(Instruction.I_TO_O);
            }
            compiler.generate(new PushValueInt(this.size()));
            compiler.generate(Instruction.CHECK_ARRAY_SIZE);
        } else {
            this._indexable.compile(compiler);
            compiler.generate(Instruction.RECONCILE_INDEXABLES);
        }
        if (this._indexSet.checkedType().isInt()) {
            switch (((ArrayType)this._checkedType).baseType().boxSort()) {
                case 1: {
                    compiler.generate(Instruction.MAKE_ARRAY_I);
                    return;
                }
                case 2: {
                    compiler.generate(Instruction.MAKE_ARRAY_R);
                    return;
                }
            }
            compiler.generate(Instruction.MAKE_ARRAY_O);
            return;
        }
        switch (((ArrayType)this._checkedType).baseType().boxSort()) {
            case 1: {
                compiler.generate(Instruction.SHUFFLE_MAP_I);
                return;
            }
            case 2: {
                compiler.generate(Instruction.SHUFFLE_MAP_R);
                return;
            }
        }
        compiler.generate(Instruction.SHUFFLE_MAP_O);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._indexSet != null) {
            stringBuilder.append("|").append(this._indexSet).append("|");
        }
        stringBuilder.append("#[");
        int n = this.size();
        if (this._indexable == null) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this._elements[i]).append(i == n - 1 ? "" : ",");
            }
        } else {
            Expression[] expressionArray = ((NewSet)this._indexable).elements();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(expressionArray[i]).append(":").append(this._elements[i]).append(i == n - 1 ? "" : ",");
            }
        }
        stringBuilder.append("]#");
        return stringBuilder.toString();
    }
}

