/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushValueInt;
import hlt.language.design.kernel.ArrayExtension;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Dummy;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.Let;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.SetType;
import hlt.language.design.types.Symbol;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import hlt.language.util.ArrayList;
import java.util.AbstractList;

public class ArrayInitializer
extends ProtoExpression {
    private Type _elementType;
    private Expression[] _dimension;
    private Expression _array;
    private int _extensionDepth;

    private ArrayInitializer(Type type, ArrayList arrayList, Expression expression) {
        this._elementType = type;
        this._dimension = new Expression[arrayList.size()];
        int n = this._dimension.length;
        while (n-- > 0) {
            this._dimension[n] = (Expression)arrayList.get(n);
        }
        this._array = expression;
        this._extensionDepth = this.maxExtensionDepth(this._array, 0);
    }

    private ArrayInitializer(Type type, Expression[] expressionArray, Expression expression, int n) {
        this._elementType = type;
        this._dimension = expressionArray;
        this._array = expression;
        this._extensionDepth = n;
    }

    @Override
    public final Expression copy() {
        Expression[] expressionArray = new Expression[this._dimension.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._dimension[n].copy();
        }
        return new ArrayInitializer(this._elementType, expressionArray, this._array.copy(), this._extensionDepth);
    }

    @Override
    public final Expression typedCopy() {
        Expression[] expressionArray = new Expression[this._dimension.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._dimension[n].typedCopy();
        }
        return new ArrayInitializer(this._elementType, expressionArray, this._array.typedCopy(), this._extensionDepth);
    }

    public static final Let construct(Type type, AbstractList abstractList, Expression expression) {
        ArrayList arrayList = new ArrayList(abstractList.size());
        ArrayList arrayList2 = new ArrayList(abstractList.size());
        for (int i = 0; i < abstractList.size(); ++i) {
            String string = ("$dimension_" + (i + 1) + "$").intern();
            arrayList.add(string);
            arrayList2.add(new Dummy(string).setExtent((Expression)abstractList.get(i)));
        }
        return new Let(arrayList, abstractList, (Expression)new ArrayInitializer(type, arrayList2, expression));
    }

    private final int maxExtensionDepth(Expression expression, int n) {
        if (n < this._dimension.length && expression instanceof ArrayExtension) {
            ArrayExtension arrayExtension = (ArrayExtension)expression;
            arrayExtension.setIndexSet(this._dimension[n]);
            Expression[] expressionArray = arrayExtension.elements();
            ++n;
            int n2 = 0;
            int n3 = arrayExtension.size();
            while (n3-- > 0) {
                n2 = Math.min(n2, this.maxExtensionDepth(expressionArray[n3], n));
            }
            return 1 + n2;
        }
        return 0;
    }

    @Override
    public final int numberOfSubexpressions() {
        return this._dimension.length + 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (0 <= n && n < this._dimension.length) {
            return this._dimension[n];
        }
        if (n == this._dimension.length) {
            return this._array;
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (0 <= n && n < this._dimension.length) {
            this._dimension[n] = expression;
        } else if (n == this._dimension.length) {
            this._array = expression;
        } else {
            throw new NoSuchSubexpressionException(this, n);
        }
        return this;
    }

    public final Type elementType() {
        return this._elementType.value();
    }

    public final Expression[] dimension() {
        return this._dimension;
    }

    public final Expression array() {
        return this._array;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        this._array.setCheckedType();
        int n = this._dimension.length;
        while (n-- > 0) {
            this._dimension[n].setCheckedType();
        }
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        int n = this._dimension.length;
        while (n-- > 0) {
            this._dimension[n].typeCheck(Global.dummyIndexSet(), typeChecker);
        }
        typeChecker.typeCheck(this, this.elementType().array(this._dimension));
        this._array.typeCheck(this.elementType().array(this._dimension.length), typeChecker);
        if (this.elementType().isVoid()) {
            typeChecker.error(new TypingErrorException((Object)"void array base type"), this);
        }
        n = this._dimension.length;
        while (n-- > 0) {
            this._dimensionDummy(this._dimension[n].type(), n).typeCheck(((ArrayType)this._array.type()).dimension(n), typeChecker);
        }
    }

    private Expression _dimensionDummy(Type type, int n) {
        Symbol symbol = new Symbol("indexer " + (n + 1));
        symbol.getCodeEntry(Type.INT());
        if (type.isSet()) {
            symbol.getCodeEntry(new SetType(type.baseType()));
        }
        if (type == Type.INT_RANGE) {
            symbol.getCodeEntry(Type.INT_RANGE);
            symbol.getCodeEntry(new SetType(Type.INT()));
        }
        return new Global(symbol).setExtent(this._dimension[n]);
    }

    @Override
    public final void compile(Compiler compiler) {
        this._array.compile(compiler);
        int n = this._dimension.length;
        while (n-- > 0) {
            this._dimension[n].compile(compiler);
            if (this._dimension[n].checkedType().boxSort() != 1) continue;
            compiler.generate(Instruction.I_TO_O);
        }
        compiler.generate(new PushValueInt(this._dimension.length));
        compiler.generate(new PushValueInt(this._extensionDepth));
        compiler.generate(Instruction.ARRAY_INITIALIZE);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._elementType.value());
        for (int i = 0; i < this._dimension.length; ++i) {
            stringBuilder.append("[").append(this._dimension[i]).append("]");
        }
        return stringBuilder.append(" = ").append(this._array).toString();
    }
}

