/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.ArrayIndexTypeGoal;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;

public class ArraySlot
extends ProtoExpression {
    private Expression _array;
    private Expression _index;

    public ArraySlot(Expression expression, Expression expression2) {
        this._array = expression;
        this._index = expression2;
    }

    @Override
    public final Expression copy() {
        return new ArraySlot(this._array.copy(), this._index.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new ArraySlot(this._array.typedCopy(), this._index.typedCopy()).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._array;
            }
            case 1: {
                return this._index;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._array = expression;
                break;
            }
            case 1: {
                this._index = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    public final Expression array() {
        return this._array;
    }

    public final Expression index() {
        return this._index;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        this._array.setCheckedType();
        this._index.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        TypeParameter typeParameter = new TypeParameter();
        ArrayType arrayType = new ArrayType(this.typeRef(), typeParameter);
        this._array.typeCheck(arrayType, typeChecker);
        Global.dummyIndexSet().typeCheck(typeParameter, typeChecker);
        this._index.typeCheck(typeChecker);
        typeChecker.prove(new ArrayIndexTypeGoal(this._index, arrayType));
        typeChecker.disallowVoid(this.type(), this, "array base");
    }

    @Override
    public final void compile(Compiler compiler) {
        ArrayType arrayType = (ArrayType)this._array.checkedType();
        boolean bl = arrayType.isMap();
        boolean bl2 = arrayType.indexType().boxSort() == 1;
        this._index.compile(compiler);
        if (bl2 && this._index.checkedType().isBoxedType()) {
            compiler.generateUnwrapper((byte)1);
        }
        this._array.compile(compiler);
        switch (this.boxSort()) {
            case 1: {
                if (bl) {
                    if (bl2) {
                        compiler.generate(Instruction.GET_INT_INDEXED_MAP_I);
                    } else {
                        compiler.generate(Instruction.GET_MAP_I);
                    }
                } else {
                    compiler.generate(Instruction.GET_ARRAY_I);
                }
                return;
            }
            case 2: {
                if (bl) {
                    if (bl2) {
                        compiler.generate(Instruction.GET_INT_INDEXED_MAP_R);
                    } else {
                        compiler.generate(Instruction.GET_MAP_R);
                    }
                } else {
                    compiler.generate(Instruction.GET_ARRAY_R);
                }
                return;
            }
        }
        if (bl) {
            if (bl2) {
                compiler.generate(Instruction.GET_INT_INDEXED_MAP_O);
            } else {
                compiler.generate(Instruction.GET_MAP_O);
            }
        } else {
            compiler.generate(Instruction.GET_ARRAY_O);
        }
    }

    public final String toString() {
        return this._array + "[" + this._index + "]";
    }
}

