/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.ArraySlot;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class ArraySlotUpdate
extends ProtoExpression {
    private Expression _slot;
    private Expression _value;
    private boolean _slotIsBoxed = false;
    private boolean _valueIsBoxed = false;

    public ArraySlotUpdate(Expression expression, Expression expression2) {
        this._slot = expression;
        this._value = expression2;
    }

    @Override
    public final Expression copy() {
        return new ArraySlotUpdate(this._slot.copy(), this._value.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new ArraySlotUpdate(this._slot.typedCopy(), this._value.typedCopy()).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._slot;
            }
            case 1: {
                return this._value;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._slot = expression;
                break;
            }
            case 1: {
                this._value = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    public final Expression array() {
        return ((ArraySlot)this._slot).array();
    }

    public final Expression index() {
        return ((ArraySlot)this._slot).index();
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        this._slot.setCheckedType();
        this._value.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._slot.typeCheck(typeChecker);
        this._slotIsBoxed = this._slot.type().isBoxedType();
        this._value.typeCheck(typeChecker);
        this._valueIsBoxed = this._value.type().isBoxedType();
        if (VOID_ASSIGNMENTS) {
            typeChecker.unify(this._slot.typeRef(), this._value.typeRef());
            typeChecker.typeCheck(this, Type.VOID);
        } else {
            typeChecker.typeCheck(this, this._slot.typeRef());
            typeChecker.typeCheck(this, this._value.typeRef());
            this.type().setBoxed(this._slotIsBoxed);
        }
    }

    @Override
    public final void compile(Compiler compiler) {
        ArrayType arrayType = (ArrayType)this.array().checkedType();
        boolean bl = arrayType.isMap();
        boolean bl2 = arrayType.indexType().boxSort() == 1;
        this.index().compile(compiler);
        if (bl2 && this.index().checkedType().isBoxedType()) {
            compiler.generateUnwrapper((byte)1);
        }
        this.array().compile(compiler);
        this._value.compile(compiler);
        if (this._slotIsBoxed) {
            if (!this._valueIsBoxed) {
                compiler.generateWrapper(this._value.sort());
            }
        } else if (this._valueIsBoxed) {
            compiler.generateUnwrapper(this._value.sort());
        }
        byte by = this._slotIsBoxed ? (byte)3 : (byte)this._value.sort();
        compiler.generate(this._setArraySlot(bl, bl2, by));
        if (VOID_ASSIGNMENTS) {
            compiler.generateStackPop(by);
        }
    }

    private final Instruction _setArraySlot(boolean bl, boolean bl2, byte by) {
        if (bl) {
            switch (by) {
                case 1: {
                    return bl2 ? Instruction.SET_INT_INDEXED_MAP_I : Instruction.SET_MAP_I;
                }
                case 2: {
                    return bl2 ? Instruction.SET_INT_INDEXED_MAP_R : Instruction.SET_MAP_R;
                }
            }
            return bl2 ? Instruction.SET_INT_INDEXED_MAP_O : Instruction.SET_MAP_O;
        }
        switch (by) {
            case 1: {
                return Instruction.SET_ARRAY_I;
            }
            case 2: {
                return Instruction.SET_ARRAY_R;
            }
        }
        return Instruction.SET_ARRAY_O;
    }

    public final String toString() {
        return this._slot + " = " + this._value;
    }
}

