/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;

public class ArrayToMap
extends ProtoExpression {
    private Expression _array;
    private Expression _indexable;

    public ArrayToMap(Expression expression, Expression expression2) {
        this._array = expression;
        this._indexable = expression2;
    }

    @Override
    public final Expression copy() {
        return new ArrayToMap(this._array.copy(), this._indexable.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new ArrayToMap(this._array.typedCopy(), this._indexable.typedCopy()).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._array;
            }
            case 1: {
                return this._indexable;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._array = expression;
                break;
            }
            case 1: {
                this._indexable = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    public final Expression array() {
        return this._array;
    }

    public final Expression indexable() {
        return this._indexable;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._array.setCheckedType();
        this._indexable.setCheckedType();
        this.setCheckedType(this.type().copy());
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        TypeParameter typeParameter = new TypeParameter();
        ArrayType arrayType = new ArrayType(typeParameter, Type.INT());
        this._array.typeCheck(arrayType, typeChecker);
        this._indexable.typeCheck(Global.dummyIndexable(), typeChecker);
        typeChecker.typeCheck(this, new ArrayType(typeParameter, this._indexable.typeRef()));
    }

    @Override
    public final void compile(Compiler compiler) {
        this._indexable.compile(compiler);
        this._array.compile(compiler);
        switch (((ArrayType)this._array.checkedType()).baseType().boxSort()) {
            case 1: {
                compiler.generate(Instruction.ARRAY_TO_MAP_I);
                break;
            }
            case 2: {
                compiler.generate(Instruction.ARRAY_TO_MAP_R);
                break;
            }
            case 3: {
                compiler.generate(Instruction.ARRAY_TO_MAP_O);
            }
        }
    }

    public final String toString() {
        return "array2map(" + this._array + "," + this._indexable + ")";
    }
}

