/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public abstract class Assignment
extends ProtoExpression {
    protected Expression _lhs;
    protected Expression _rhs;

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._lhs;
            }
            case 1: {
                return this._rhs;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._lhs = expression;
                break;
            }
            case 1: {
                this._rhs = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._checkedType = this.type().copy();
        this._lhs.setCheckedType();
        this._rhs.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        Type type = VOID_ASSIGNMENTS ? this._rhs.typeRef() : this._type;
        this._lhs.typeCheck(type, typeChecker);
        this._rhs.typeCheck(type, typeChecker);
        typeChecker.disallowVoid(type.value(), this, "assigned value");
        if (VOID_ASSIGNMENTS) {
            typeChecker.unify(this._type, Type.VOID, this);
        }
    }

    public final String toString() {
        return this._lhs + " = " + this._rhs;
    }
}

