/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.BoxingUnboxingInstruction;
import hlt.language.design.instructions.Enter;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.Jump;
import hlt.language.design.instructions.PushInt;
import hlt.language.design.instructions.PushObject;
import hlt.language.design.instructions.PushReal;
import hlt.language.design.instructions.PushScope;
import hlt.language.design.instructions.Relocatable;
import hlt.language.design.instructions.SetElementInstruction;
import hlt.language.design.kernel.Expression;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.DefinedEntry;
import hlt.language.util.ArrayList;
import hlt.language.util.Queue;
import java.util.HashSet;

public class Compiler {
    private Queue _pushScopeQueue = new Queue();
    private ArrayList _codeList = new ArrayList();
    private Instruction[] _code;
    private int _codeEnd = 0;
    private DefinedEntry _codeEntry;
    private boolean _showCode = false;
    private HashSet _targets = new HashSet();
    public static boolean LCO_IS_EFFECTIVE = false;

    private final void _reset() {
        this._codeList.clear();
        this._targets.clear();
        this._code = null;
        this._codeEnd = 0;
    }

    public final Instruction[] code() {
        return this._code;
    }

    public final int nextCodeAddress() {
        return this._codeEnd;
    }

    public final int targetAddress() {
        this._targets.add(new Integer(this._codeEnd));
        return this._codeEnd;
    }

    public final void setCodeEntry(DefinedEntry definedEntry) {
        this._codeEntry = definedEntry;
    }

    public final DefinedEntry codeEntry() {
        return this._codeEntry;
    }

    public final boolean isCompilingDefinition() {
        return this._codeEntry != null;
    }

    private final void _releaseCodeEntry() {
        this._codeEntry.setCode(this.code());
        if (this._codeEntry.isField()) {
            this._codeEntry.setInitCode();
        }
        this._codeEntry.releaseUnsafeEntries();
    }

    public final void compile(Expression expression) {
        this._reset();
        expression.compile(this);
        this._backpatch();
        if (this.isCompilingDefinition()) {
            this._releaseCodeEntry();
        }
        if (this._showCode) {
            this.showCode();
        }
        this._codeEntry = null;
    }

    private final Compiler _backpatch() {
        this.generate(Instruction.END);
        block5: while (!this._pushScopeQueue.isEmpty()) {
            ScopeBody scopeBody = (ScopeBody)this._pushScopeQueue.pop();
            scopeBody.pushScope.setAddress(this.nextCodeAddress());
            scopeBody.body.compile(this);
            Instruction instruction = this.lastInstruction();
            if (LCO_IS_EFFECTIVE && !this._isTarget(this._codeEnd) && !scopeBody.pushScope.isExitable() && instruction instanceof Enter) {
                --this._codeEnd;
                this.generate(((Enter)instruction).setLCO());
                this.generate(Instruction.END);
                continue;
            }
            switch (scopeBody.body.boxSort()) {
                case 0: {
                    this.generate(Instruction.RETURN_VOID);
                    continue block5;
                }
                case 1: {
                    this.generate(Instruction.RETURN_I);
                    continue block5;
                }
                case 2: {
                    this.generate(Instruction.RETURN_R);
                    continue block5;
                }
            }
            this.generate(Instruction.RETURN_O);
        }
        this._extractCode();
        return this;
    }

    private final void _extractCode() {
        this._code = new Instruction[this._codeEnd];
        for (int i = 0; i < this._code.length; ++i) {
            this._code[i] = (Instruction)this._codeList.get(i);
            if (!(this._code[i] instanceof PushScope)) continue;
            this._code[i] = ((PushScope)this._code[i]).setReferenceCode(this._code);
        }
    }

    public final Instruction lastInstruction() {
        return (Instruction)this._codeList.get(this._codeEnd - 1);
    }

    public final void toggleShowCode() {
        this._showCode = !this._showCode;
    }

    public final boolean isShowingCode() {
        return this._showCode;
    }

    public final void showCode() {
        CodeEntry.showCode(this._codeEntry, this._code);
    }

    public final Instruction generate(Instruction instruction) {
        if (instruction == Instruction.NO_OP) {
            return instruction;
        }
        instruction = this._checkSetInstruction(instruction);
        if (this._codeEnd < this._codeList.size()) {
            this._codeList.set(this._codeEnd, instruction);
        } else {
            this._codeList.add(instruction);
        }
        ++this._codeEnd;
        return instruction;
    }

    private final Instruction _checkSetInstruction(Instruction instruction) {
        if (this._codeEnd == 0) {
            return instruction;
        }
        Instruction instruction2 = this.lastInstruction();
        if (!(instruction instanceof SetElementInstruction) || !(instruction2 instanceof BoxingUnboxingInstruction)) {
            return instruction;
        }
        SetElementInstruction setElementInstruction = (SetElementInstruction)instruction;
        switch (setElementInstruction.id()) {
            case 2: 
            case 5: 
            case 8: {
                if (instruction2 == Instruction.I_TO_O) {
                    --this._codeEnd;
                    switch (setElementInstruction.id()) {
                        case 2: {
                            return Instruction.SET_ADD_I;
                        }
                        case 5: {
                            return Instruction.SET_RMV_I;
                        }
                        case 8: {
                            return Instruction.BELONGS_I;
                        }
                    }
                    break;
                }
                if (instruction2 != Instruction.R_TO_O) break;
                --this._codeEnd;
                switch (setElementInstruction.id()) {
                    case 2: {
                        return Instruction.SET_ADD_R;
                    }
                    case 5: {
                        return Instruction.SET_RMV_R;
                    }
                    case 8: {
                        return Instruction.BELONGS_R;
                    }
                }
            }
        }
        if (instruction2 == Instruction.O_TO_I || instruction2 == Instruction.O_TO_R) {
            --this._codeEnd;
            switch (setElementInstruction.id()) {
                case 0: 
                case 1: {
                    return Instruction.SET_ADD_O;
                }
                case 3: 
                case 4: {
                    return Instruction.SET_RMV_O;
                }
                case 6: 
                case 7: {
                    return Instruction.BELONGS_O;
                }
            }
        }
        return instruction;
    }

    public final Instruction generate(PushScope pushScope, Expression expression) {
        this._pushScopeQueue.push(new ScopeBody(pushScope, expression, this._codeEnd));
        return this.generate(pushScope);
    }

    public final void inline(Instruction[] instructionArray) {
        for (int i = 0; i < instructionArray.length; ++i) {
            if (instructionArray[i] == Instruction.END) {
                return;
            }
            if (instructionArray[i] instanceof Relocatable) {
                Relocatable relocatable = (Relocatable)instructionArray[i];
                this.generate(relocatable.relocate(this._codeEnd - i + relocatable.address()));
                continue;
            }
            this.generate(instructionArray[i]);
        }
    }

    private final boolean _isTarget(int n) {
        return this._targets.contains(new Integer(n));
    }

    private final void _skipPush(Instruction instruction) {
        if (!this._isTarget(this._codeEnd)) {
            --this._codeEnd;
        } else {
            this.generate(instruction);
            this._codeList.set(this._codeEnd - 2, new Jump(this.targetAddress()));
        }
    }

    public final void generateStackPop(byte by) {
        Instruction instruction = this.lastInstruction();
        switch (by) {
            case 0: {
                return;
            }
            case 1: {
                if (instruction instanceof PushInt) {
                    this._skipPush(Instruction.POP_I);
                } else {
                    this.generate(Instruction.POP_I);
                }
                return;
            }
            case 2: {
                if (instruction instanceof PushReal) {
                    this._skipPush(Instruction.POP_R);
                } else {
                    this.generate(Instruction.POP_R);
                }
                return;
            }
        }
        if (instruction instanceof PushObject) {
            this._skipPush(Instruction.POP_O);
        } else {
            this.generate(Instruction.POP_O);
        }
    }

    public final void generateWrapper(byte by) {
        Instruction instruction = this.lastInstruction();
        switch (by) {
            case 1: {
                if (instruction == Instruction.O_TO_I) {
                    --this._codeEnd;
                } else {
                    this.generate(Instruction.I_TO_O);
                }
                return;
            }
            case 2: {
                if (instruction == Instruction.O_TO_R) {
                    --this._codeEnd;
                } else {
                    this.generate(Instruction.R_TO_O);
                }
                return;
            }
        }
    }

    public final void generateUnwrapper(byte by) {
        Instruction instruction = this.lastInstruction();
        switch (by) {
            case 1: {
                if (instruction == Instruction.I_TO_O) {
                    --this._codeEnd;
                } else {
                    this.generate(Instruction.O_TO_I);
                }
                return;
            }
            case 2: {
                if (instruction == Instruction.R_TO_O) {
                    --this._codeEnd;
                } else {
                    this.generate(Instruction.O_TO_R);
                }
                return;
            }
        }
    }

    private static class ScopeBody {
        PushScope pushScope;
        Expression body;

        ScopeBody(PushScope pushScope, Expression expression, int n) {
            this.pushScope = pushScope;
            this.body = expression;
        }
    }
}

